/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.connection.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class ChildrenList<T> {
    protected T parent;
    private Iterable<T> all;
    private List<T> children;
    protected HashMap<String, T> extensions = new HashMap();

    public ChildrenList(List<T> children) {
        this.set(children);
    }

    public T getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    protected void set(int index, T child) {
        this.children.set(index, child);
    }

    protected void set(List<T> children) {
        this.children = children != null ? new UnmodifiableList<T>(children) : Collections.EMPTY_LIST;
    }

    protected T getChildDirectly(int index) {
        return this.children.get(index);
    }

    protected abstract void added(T var1);

    public void addExtension(String key, T extension) {
        if (this.extensions.containsKey(key)) {
            throw new RuntimeException("Extension " + key + " already exists");
        }
        this.extensions.put(key, extension);
    }

    public void addExtensions(Map<String, T> extensions) {
        for (Map.Entry<String, T> pair : extensions.entrySet()) {
            this.addExtension(pair.getKey(), pair.getValue());
        }
    }

    protected T removeExt(String key) {
        return this.extensions.remove(key);
    }

    public T getExtension(String key) {
        return this.extensions.get(key);
    }

    public Iterable<T> all() {
        if (this.all == null) {
            this.all = new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return ChildrenList.this.iteratorAll();
                }
            };
        }
        return this.all;
    }

    public Iterator<T> iteratorAll() {
        return new Iterator<T>(){
            private Iterator<T> itr;
            private boolean firstItr;
            {
                this.itr = ChildrenList.this.children.iterator();
                this.firstItr = true;
            }

            @Override
            public boolean hasNext() {
                if (!this.itr.hasNext() && this.firstItr) {
                    this.itr = ChildrenList.this.extensions.values().iterator();
                    this.firstItr = false;
                }
                return this.itr.hasNext();
            }

            @Override
            public T next() {
                return this.itr.next();
            }
        };
    }

    public Iterable<T> children() {
        return this.children;
    }

    public Iterable<T> extensions() {
        return this.extensions.values();
    }

    public Iterable<Map.Entry<String, T>> extensionEntries() {
        return this.extensions.entrySet();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int sizeChildren() {
        return this.children.size();
    }

    public boolean hasExtensions() {
        return !this.extensions.isEmpty();
    }

    public int sizeExtensions() {
        return this.extensions.size();
    }

    public int size() {
        return this.children.size() + this.extensions.size();
    }

    public boolean isEmpty() {
        return this.children.isEmpty() && this.extensions.isEmpty();
    }

    static class UnmodifiableList<E>
    extends ArrayList<E> {
        UnmodifiableList(List<? extends E> list) {
            super(list);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<E> spliterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = UnmodifiableList.super.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableList(super.subList(fromIndex, toIndex));
        }
    }
}

