/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.type.tree.NamedTree;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.registry.gui.LittleBedGui;
import team.creative.littletiles.common.structure.registry.gui.LittleDoorActivatorGui;
import team.creative.littletiles.common.structure.registry.gui.LittleDoorAdvancedGui;
import team.creative.littletiles.common.structure.registry.gui.LittleDoorAxisGui;
import team.creative.littletiles.common.structure.registry.gui.LittleDoorSlidingGui;
import team.creative.littletiles.common.structure.registry.gui.LittleLightGui;
import team.creative.littletiles.common.structure.registry.gui.LittleMessageGui;
import team.creative.littletiles.common.structure.registry.gui.LittleNoClipGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStorageGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiDefault;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiNone;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiNotFound;
import team.creative.littletiles.common.structure.registry.gui.LittleStructurePremadeGui;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

@OnlyIn(value=Dist.CLIENT)
public class LittleStructureGuiRegistry {
    private static final NamedTree<LittleStructureGui> TREE = new NamedTree();
    private static final HashMap<LittleStructureType, LittleStructureGui> BY_TYPE = new HashMap();
    private static final HashMap<LittleStructureType, Consumer<GuiTreeItemStructure>> BY_TYPE_FINALIZER = new HashMap();
    private static final List<BiFunction<LittleStructureType, LittleGroup, LittleStructureGui>> SPECIAL = new ArrayList<BiFunction<LittleStructureType, LittleGroup, LittleStructureGui>>();

    public static void registerTreeOnly(String id, LittleStructureType type, BiFunction<LittleStructureGui, GuiTreeItemStructure, LittleStructureGuiControl> gui) {
        LittleStructureGuiRegistry.registerTreeOnly(new LittleStructureGui(id, type, gui));
    }

    public static void registerTreeOnly(LittleStructureGui gui) {
        TREE.add(gui.id(), (Object)gui);
    }

    public static void register(BiFunction<LittleStructureType, LittleGroup, LittleStructureGui> special) {
        SPECIAL.add(special);
    }

    public static void register(String id, LittleStructureType type, BiFunction<LittleStructureGui, GuiTreeItemStructure, LittleStructureGuiControl> factory) {
        LittleStructureGuiRegistry.register(new LittleStructureGui(id, type, factory));
    }

    public static void register(LittleStructureGui gui) {
        TREE.add(gui.id(), (Object)gui);
        BY_TYPE.put(gui.type(), gui);
    }

    public static void register(LittleStructureType type, BiFunction<LittleStructureGui, GuiTreeItemStructure, LittleStructureGuiControl> factory) {
        LittleStructureGuiRegistry.register(new LittleStructureGui(type.id, type, factory));
    }

    public static void registerByType(LittleStructureGui gui) {
        BY_TYPE.put(gui.type(), gui);
    }

    public static void registerFinalizer(Consumer<GuiTreeItemStructure> finalizer, LittleStructureType ... types) {
        for (int i = 0; i < types.length; ++i) {
            BY_TYPE_FINALIZER.put(types[i], finalizer);
        }
    }

    public static Consumer<GuiTreeItemStructure> getFinalizer(LittleStructureType type) {
        return BY_TYPE_FINALIZER.get(type);
    }

    public static Iterable<LittleStructureGui> registered() {
        return TREE;
    }

    public static LittleStructureGui get(LittleStructureType type, LittleGroup group) {
        LittleStructureGui factory = BY_TYPE.get(type);
        if (factory != null) {
            return factory;
        }
        for (int i = 0; i < SPECIAL.size(); ++i) {
            factory = SPECIAL.get(i).apply(type, group);
            if (factory == null) continue;
            return factory;
        }
        factory = new LittleStructureGui(type.id, type, LittleStructureGuiNotFound::new, false);
        BY_TYPE.put(type, factory);
        return factory;
    }

    public static LittleStructureType get(String id) {
        return (LittleStructureType)LittleStructureRegistry.REGISTRY.getOrThrow(id);
    }

    private static void controlledByTransition(GuiTreeItemStructure item, BitSet set, AnimationTimeline timeline) {
        if (timeline == null) {
            return;
        }
        for (AnimationTimeline.AnimationEventEntry entry : timeline.allEvents()) {
            AnimationEvent animationEvent = entry.getEvent();
            if (!(animationEvent instanceof ChildDoorEvent)) continue;
            ChildDoorEvent event = (ChildDoorEvent)animationEvent;
            set.set(event.childId);
        }
    }

    static {
        LittleStructureGuiRegistry.register(new LittleStructureGui("none", null, LittleStructureGuiNone::new, false));
        LittleStructureGuiRegistry.register("simple.fixed", LittleStructureGuiRegistry.get("fixed"), LittleStructureGuiDefault::new);
        LittleStructureGuiRegistry.register("simple.ladder", LittleStructureGuiRegistry.get("ladder"), LittleStructureGuiDefault::new);
        LittleStructureGuiRegistry.register("simple.bed", LittleStructureGuiRegistry.get("bed"), LittleBedGui::new);
        LittleStructureGuiRegistry.register("simple.chair", LittleStructureGuiRegistry.get("chair"), LittleStructureGuiDefault::new);
        LittleStructureGuiRegistry.register("simple.storage", LittleStructureGuiRegistry.get("storage"), LittleStorageGui::new);
        LittleStructureGuiRegistry.register("simple.noclip", LittleStructureGuiRegistry.get("noclip"), LittleNoClipGui::new);
        LittleStructureGuiRegistry.register("simple.light", LittleStructureGuiRegistry.get("light"), LittleLightGui::new);
        LittleStructureGuiRegistry.register("simple.message", LittleStructureGuiRegistry.get("message"), LittleMessageGui::new);
        LittleStructureType axis = LittleStructureGuiRegistry.get("axis");
        LittleStructureType sliding = LittleStructureGuiRegistry.get("sliding");
        LittleStructureType advanced = LittleStructureGuiRegistry.get("door");
        LittleStructureType activator = LittleStructureGuiRegistry.get("activator");
        LittleStructureGuiRegistry.register("door.axis", axis, LittleDoorAxisGui::new);
        LittleStructureGuiRegistry.register("door.sliding", sliding, LittleDoorSlidingGui::new);
        LittleStructureGuiRegistry.register("door.advanced", advanced, LittleDoorAdvancedGui::new);
        LittleStructureGuiRegistry.register("door.activator", activator, LittleDoorActivatorGui::new);
        LittleStructureGuiRegistry.registerFinalizer(x -> {
            LittleDoor door = (LittleDoor)x.structure;
            BitSet set = new BitSet();
            LittleStructureGuiRegistry.controlledByTransition(x, set, door.getTransition("opening"));
            LittleStructureGuiRegistry.controlledByTransition(x, set, door.getTransition("closing"));
            for (int i = 0; i < x.itemsCount(); ++i) {
                LittleStructure patt6122$temp = ((GuiTreeItemStructure)x.getItem((int)i)).structure;
                if (!(patt6122$temp instanceof LittleDoor)) continue;
                LittleDoor child = (LittleDoor)patt6122$temp;
                child.activateParent = set.get(i);
            }
        }, axis, sliding, advanced, activator);
        LittleStructureGuiRegistry.register((LittleStructureType x, LittleGroup y) -> {
            if (x instanceof LittleStructurePremade.LittlePremadeType) {
                LittleStructureGui gui = new LittleStructureGui(x.id, (LittleStructureType)x, LittleStructurePremadeGui::new);
                LittleStructureGuiRegistry.registerByType(gui);
                return gui;
            }
            return null;
        });
    }
}

