/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;

public class LittleStructureMessage
extends LittleStructure {
    public String text;
    public boolean allowRightClick = true;

    public LittleStructureMessage(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canInteract() {
        return this.allowRightClick;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (this.allowRightClick) {
            player.m_5661_((Component)Component.m_237113_((String)this.text), true);
            return InteractionResult.SUCCESS;
        }
        return super.use(level, context, pos, player, result);
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.text = nbt.m_128461_("text");
        this.allowRightClick = nbt.m_128471_("right");
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128359_("text", this.text);
        nbt.m_128379_("right", this.allowRightClick);
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("message")) {
            Level level = this.getLevel();
            if (level.f_46443_) {
                return;
            }
            LevelChunk chunk = level.m_46745_(this.getPos());
            if (chunk != null) {
                ((ServerChunkCache)chunk.m_62953_().m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(x -> x.m_213846_((Component)Component.m_237113_((String)this.text)));
            }
        }
    }
}

