/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.animation;

import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxRelative;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxRelativeAxis;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;
import team.creative.littletiles.common.structure.directional.StructureDirectionalType;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;
import team.creative.littletiles.common.structure.type.animation.LittleStateStructure;

public class LittleAxisDoor
extends LittleDoor {
    @StructureDirectional
    public LittleAxisDoorRotation rotation;

    public static void load() {
        StructureDirectionalType.registerType(LittleAxisDoorRotation.class, new StructureDirectionalType<LittleAxisDoorRotation>(){

            @Override
            public LittleAxisDoorRotation read(Tag nbt) {
                if (nbt instanceof CompoundTag) {
                    CompoundTag tag = (CompoundTag)nbt;
                    Axis axis = Axis.values()[tag.m_128451_("a")];
                    if (tag.m_128441_("d")) {
                        return new LittleAxisDoorRotationFixed(axis, tag.m_128459_("d"));
                    }
                    return new LittleAxisDoorRotationDirection(axis, tag.m_128471_("c"));
                }
                return null;
            }

            @Override
            public Tag write(LittleAxisDoorRotation value) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("a", value.axis.ordinal());
                if (value instanceof LittleAxisDoorRotationFixed) {
                    LittleAxisDoorRotationFixed fixed = (LittleAxisDoorRotationFixed)value;
                    nbt.m_128347_("d", fixed.degree);
                } else {
                    nbt.m_128379_("c", ((LittleAxisDoorRotationDirection)value).clockwise);
                }
                return nbt;
            }

            @Override
            public LittleAxisDoorRotation move(LittleAxisDoorRotation value, LittleVecGrid vec) {
                return value;
            }

            @Override
            public LittleAxisDoorRotation mirror(LittleAxisDoorRotation value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                value.mirror(axis);
                return value;
            }

            @Override
            public LittleAxisDoorRotation rotate(LittleAxisDoorRotation value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                value.rotate(rotation);
                return value;
            }

            @Override
            public LittleAxisDoorRotation getDefault() {
                return new LittleAxisDoorRotationDirection(Axis.Y, true);
            }
        });
    }

    public LittleAxisDoor(LittleStateStructure.LittleStateStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    public static abstract class LittleAxisDoorRotation {
        public Axis axis;

        public LittleAxisDoorRotation(Axis axis) {
            this.axis = axis;
        }

        public abstract void mirror(Axis var1);

        public void rotate(Rotation rotation) {
            this.axis = rotation.rotate(this.axis);
            this.rotateInternal(rotation);
        }

        protected abstract void rotateInternal(Rotation var1);

        public abstract void apply(PhysicalState var1);
    }

    public static class LittleDoorTypeAxisCenter
    extends LittleDoor.LittleDoorType {
        public <T extends LittleDoor> LittleDoorTypeAxisCenter(String id, Class<T> structureClass, BiFunction<? extends LittleStateStructure.LittleStateStructureType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute) {
            super(id, structureClass, factory, attribute);
        }

        @Override
        protected LittlePlaceBoxRelative getPlaceBox(Object value, StructureDirectionalField type, LittleGroup previews) {
            if (type.key.equals("center")) {
                return new LittlePlaceBoxRelativeAxis(((StructureRelative)value).getBox(), (StructureRelative)value, type, Axis.values()[previews.getStructureTag().m_128469_("rotation").m_128451_("a")]);
            }
            return super.getPlaceBox(value, type, previews);
        }
    }

    public static class LittleAxisDoorRotationFixed
    extends LittleAxisDoorRotation {
        public double degree;

        public LittleAxisDoorRotationFixed(Axis axis, double degree) {
            super(axis);
            this.degree = degree;
        }

        @Override
        public void mirror(Axis axis) {
            if (this.axis == axis) {
                this.degree = -this.degree;
            }
        }

        @Override
        protected void rotateInternal(Rotation rotation) {
            this.degree = Rotation.getRotation((Axis)this.axis, (boolean)(this.degree > 0.0 ? true : false)).rotate((Rotation)rotation).clockwise ? Math.abs(this.degree) : -Math.abs(this.degree);
        }

        @Override
        public void apply(PhysicalState state) {
            state.rot(this.axis, this.degree);
        }
    }

    public static class LittleAxisDoorRotationDirection
    extends LittleAxisDoorRotation {
        public boolean clockwise;

        public LittleAxisDoorRotationDirection(Axis axis, boolean clockwise) {
            super(axis);
            this.clockwise = clockwise;
        }

        @Override
        public void mirror(Axis axis) {
            if (this.axis == axis) {
                this.clockwise = !this.clockwise;
            }
        }

        @Override
        protected void rotateInternal(Rotation rotation) {
            this.clockwise = Rotation.getRotation((Axis)this.axis, (boolean)this.clockwise).rotate((Rotation)rotation).clockwise;
        }

        @Override
        public void apply(PhysicalState state) {
            state.rot(this.axis, this.clockwise ? 90.0 : -90.0);
        }
    }
}

