/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.bed;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.common.structure.type.bed.LittleBed;

public class LittleBedEventHandler {
    @SubscribeEvent
    public void isSleepingLocationAllowed(SleepingLocationCheckEvent event) {
        Player player;
        LittleBed bed;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (bed = ((ILittleBedPlayerExtension)(player = (Player)livingEntity)).getBed()) != null && bed.getSleepingPlayer() == player) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        LittleBed bed = ((ILittleBedPlayerExtension)event.getEntity()).getBed();
        if (bed != null) {
            bed.setSleepingPlayer(null);
        }
        ((ILittleBedPlayerExtension)event.getEntity()).setBed(null);
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        LittleBed bed = ((ILittleBedPlayerExtension)event.getEntity()).getBed();
        if (bed != null) {
            bed.setSleepingPlayer(null);
        }
        ((ILittleBedPlayerExtension)event.getEntity()).setBed(null);
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        BETiles be;
        if (event.getEntity().f_19853_.m_8055_(event.getPos()).m_60734_() instanceof BlockTile && (be = BlockTile.loadBE((BlockGetter)event.getEntity().f_19853_, event.getPos())) != null) {
            for (LittleStructure structure : be.loadedStructures()) {
                if (!(structure instanceof LittleBed) || !((LittleBed)structure).hasBeenActivated) continue;
                try {
                    ((LittleBed)structure).trySleep(event.getEntity(), structure.getHighestCenterVec());
                    event.setResult((Player.BedSleepingProblem)null);
                    ((LittleBed)structure).hasBeenActivated = false;
                    return;
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

