/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.level.LittleChunkDispatcher;
import team.creative.littletiles.client.render.level.LittleClientEventHandler;
import team.creative.littletiles.mixin.client.render.LevelRendererAccessor;

@Mixin(value={LevelRenderer.class}, priority=1500)
public class LevelRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"allChanged()V"})
    public void allChanged(CallbackInfo info) {
        LittleChunkDispatcher.onReloadRenderers((LevelRenderer)this);
    }

    @Inject(at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=blockentities"})}, method={"renderLevel"})
    public void renderBlockEntities(PoseStack pose, float frameTime, long time, boolean outOfMemory, Camera cam, GameRenderer renderer, LightTexture lightTexture, Matrix4f matrix, CallbackInfo info) {
        Frustum frustum;
        Frustum frustum2 = frustum = ((LevelRendererAccessor)((Object)this)).getCapturedFrustum() != null ? ((LevelRendererAccessor)((Object)this)).getCapturedFrustum() : ((LevelRendererAccessor)((Object)this)).getCullingFrustum();
        if (LittleTilesClient.ANIMATION_HANDLER != null) {
            LittleTilesClient.ANIMATION_HANDLER.renderBlockEntitiesAndDestruction(pose, frustum, frameTime);
        }
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;zTransparentOld:D", opcode=181)}, method={"renderChunkLayer"})
    public void resortTransparency(RenderType layer, PoseStack pose, double x, double y, double z, Matrix4f projectionMatrix, CallbackInfo info) {
        ++LittleClientEventHandler.transparencySortingIndex;
        if (LittleTilesClient.ANIMATION_HANDLER != null) {
            LittleTilesClient.ANIMATION_HANDLER.resortTransparency(layer, x, y, z);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"needsUpdate()V"})
    public void needsUpdate(CallbackInfo info) {
        if (LittleTilesClient.ANIMATION_HANDLER != null) {
            LittleTilesClient.ANIMATION_HANDLER.needsUpdate();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"})
    public void setupRender(Camera camera, Frustum frustum, boolean capturedFrustum, boolean spectator, CallbackInfo info) {
        if (LittleTilesClient.ANIMATION_HANDLER != null) {
            LittleTilesClient.ANIMATION_HANDLER.setupRender(camera, frustum, capturedFrustum, spectator);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"compileChunks(Lnet/minecraft/client/Camera;)V"})
    public void compileChunks(Camera camera, CallbackInfo info) {
        if (LittleTilesClient.ANIMATION_HANDLER != null) {
            LittleTilesClient.ANIMATION_HANDLER.compileChunks(camera);
        }
    }
}

