/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.collision;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;

@Mixin(value={BlockCollisions.class})
public class BlockCollisionsMixin {
    @Shadow
    @Final
    private AABB f_186392_;
    @Shadow
    @Final
    private CollisionContext f_186393_;
    @Shadow
    @Final
    private CollisionGetter f_186397_;
    @Shadow
    @Final
    private BlockPos.MutableBlockPos f_186395_;
    @Unique
    private Iterator<VoxelShape> extraShapes;

    @Inject(method={"computeNext"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Cursor3D;advance()Z")}, cancellable=true, require=1)
    private void computeStart(CallbackInfoReturnable<VoxelShape> info) {
        if (this.extraShapes != null) {
            if (this.extraShapes.hasNext()) {
                info.setReturnValue((Object)this.extraShapes.next());
            } else {
                this.extraShapes = null;
            }
        }
    }

    @Inject(method={"computeNext"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;")}, require=1, locals=LocalCapture.CAPTURE_FAILHARD)
    private void computeBlock(CallbackInfoReturnable<VoxelShape> info, int i, int j, int k, int l, BlockGetter blockgetter, BlockState blockstate) {
        BlockTile block;
        List<VoxelShape> list;
        Block block2 = blockstate.m_60734_();
        if (block2 instanceof BlockTile && (list = (block = (BlockTile)block2).getOddShapes(blockstate, (BlockGetter)this.f_186397_, (BlockPos)this.f_186395_, this.f_186393_, this.f_186392_)) != null) {
            this.extraShapes = list.iterator();
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/CollisionGetter;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Z)V"}, at={@At(value="RETURN")}, require=1)
    private void constructorEnd(CollisionGetter level, @Nullable Entity entity, AABB bb, boolean onlySuffocatingBlocks, CallbackInfo info) {
        if (!(this.f_186397_ instanceof Level)) {
            return;
        }
        Iterable<VoxelShape> shapes = ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get((Level)this.f_186397_)).collisionExcept(entity, this.f_186392_, (Level)this.f_186397_);
        if (shapes != null) {
            this.extraShapes = shapes.iterator();
        }
    }
}

