/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.player;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.server.player.LittleServerPlayerHandler;

public class LittleServerPlayerConnection {
    private static final HashMap<ServerPlayer, LittleServerPlayerHandler> LISTENERS;

    private LittleServerPlayerConnection() {
    }

    public static void remove(ServerPlayer player) {
        LISTENERS.remove(player);
    }

    private static LittleServerPlayerHandler getOrCreate(ServerPlayer player) {
        LittleServerPlayerHandler listener = LISTENERS.get(player);
        if (listener == null) {
            listener = new LittleServerPlayerHandler(player);
            LISTENERS.put(player, listener);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(LittleLevel level, ServerPlayer player, Packet packet) {
        LittleServerPlayerHandler listener;
        LittleServerPlayerHandler littleServerPlayerHandler = listener = LittleServerPlayerConnection.getOrCreate(player);
        synchronized (littleServerPlayerHandler) {
            Level previous = listener.level;
            listener.level = level.asLevel();
            listener.m_9829_(packet);
            listener.level = previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runInContext(LittleLevel level, ServerPlayer player, Consumer<LittleServerPlayerHandler> consumer) {
        LittleServerPlayerHandler listener;
        LittleServerPlayerHandler littleServerPlayerHandler = listener = LittleServerPlayerConnection.getOrCreate(player);
        synchronized (littleServerPlayerHandler) {
            Level previous = listener.level;
            listener.level = level.asLevel();
            consumer.accept(listener);
            listener.level = previous;
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        for (LittleServerPlayerHandler handler : LISTENERS.values()) {
            handler.m_9933_();
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        LISTENERS.remove(event.getEntity());
    }

    static {
        MinecraftForge.EVENT_BUS.register(LittleServerPlayerConnection.class);
        LISTENERS = new HashMap();
    }
}

