/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex.serializers;

import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatDescription;
import me.jellysquid.mods.sodium.client.render.vertex.serializers.MemoryTransfer;
import me.jellysquid.mods.sodium.client.render.vertex.serializers.VertexSerializer;
import me.jellysquid.mods.sodium.client.render.vertex.serializers.generated.VertexSerializerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexSerializerCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertexSerializerCache.class);
    private static final Path CLASS_DUMP_PATH;
    private static final Long2ReferenceMap<VertexSerializer> CACHE;

    public static VertexSerializer get(VertexFormatDescription srcFormat, VertexFormatDescription dstFormat) {
        long identifier = VertexSerializerCache.getSerializerKey(srcFormat, dstFormat);
        VertexSerializer serializer = (VertexSerializer)CACHE.get(identifier);
        if (serializer == null) {
            serializer = VertexSerializerCache.createSerializer(srcFormat, dstFormat);
            CACHE.put(identifier, (Object)serializer);
        }
        return serializer;
    }

    private static long getSerializerKey(VertexFormatDescription a, VertexFormatDescription b) {
        return (long)a.id & 0xFFFFFFFFL | ((long)b.id & 0xFFFFFFFFL) << 32;
    }

    private static VertexSerializer createSerializer(VertexFormatDescription srcVertexFormat, VertexFormatDescription dstVertexFormat) {
        VertexSerializer serializer;
        Object instance;
        Constructor<?> constructor;
        String identifier = String.format("%04X$%04X", srcVertexFormat.id, dstVertexFormat.id);
        List<MemoryTransfer> desc = VertexSerializerCache.createMemoryTransferList(srcVertexFormat, dstVertexFormat);
        VertexSerializerFactory.Bytecode bytecode = VertexSerializerFactory.generate(desc, srcVertexFormat, dstVertexFormat, identifier);
        if (CLASS_DUMP_PATH != null) {
            VertexSerializerCache.dumpClass(identifier, bytecode);
        }
        Class<?> clazz = VertexSerializerFactory.define(bytecode);
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find constructor of generated class", e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate generated class", e);
        }
        try {
            serializer = (VertexSerializer)instance;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Failed to cast generated class to interface type", e);
        }
        return serializer;
    }

    private static List<MemoryTransfer> createMemoryTransferList(VertexFormatDescription srcVertexFormat, VertexFormatDescription dstVertexFormat) {
        if (srcVertexFormat.elementCount < dstVertexFormat.elementCount) {
            throw new IllegalArgumentException("Source format has fewer elements than destination format");
        }
        ArrayList<MemoryTransfer> ops = new ArrayList<MemoryTransfer>();
        List<VertexFormatElement> srcElements = srcVertexFormat.getElements();
        IntList srcOffsets = srcVertexFormat.getOffsets();
        List<VertexFormatElement> dstElements = dstVertexFormat.getElements();
        IntList dstOffsets = dstVertexFormat.getOffsets();
        for (int dstIndex = 0; dstIndex < dstElements.size(); ++dstIndex) {
            VertexFormatElement dstElement = dstElements.get(dstIndex);
            int srcIndex = srcElements.indexOf(dstElement);
            if (srcIndex == -1) {
                throw new RuntimeException("Source vertex format does not contain element: " + String.valueOf(dstElement));
            }
            int srcOffset = srcOffsets.getInt(srcIndex);
            int dstOffset = dstOffsets.getInt(dstIndex);
            ops.add(new MemoryTransfer(srcOffset, dstOffset, dstElement.m_86050_()));
        }
        return VertexSerializerCache.mergeAdjacentMemoryTransfers(ops);
    }

    private static List<MemoryTransfer> mergeAdjacentMemoryTransfers(ArrayList<MemoryTransfer> src) {
        ArrayList<MemoryTransfer> dst = new ArrayList<MemoryTransfer>(src.size());
        int srcOffset = 0;
        int dstOffset = 0;
        int length = 0;
        for (MemoryTransfer op : src) {
            if (srcOffset + length == op.src() && dstOffset + length == op.dst()) {
                length += op.length();
                continue;
            }
            if (length > 0) {
                dst.add(new MemoryTransfer(srcOffset, dstOffset, length));
            }
            srcOffset = op.src();
            dstOffset = op.dst();
            length = op.length();
        }
        if (length > 0) {
            dst.add(new MemoryTransfer(srcOffset, dstOffset, length));
        }
        return dst;
    }

    private static void dumpClass(String id, VertexSerializerFactory.Bytecode bytecode) {
        Path path = CLASS_DUMP_PATH.resolve("VertexSerializer$Impl$%s.class".formatted(id));
        try {
            Files.write(path, bytecode.copy(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not dump bytecode to location: {}", (Object)path, (Object)e);
        }
    }

    static {
        String classDumpPath = System.getProperty("sodium.codegen.dump", null);
        CLASS_DUMP_PATH = classDumpPath != null ? Path.of(classDumpPath, new String[0]) : null;
        CACHE = new Long2ReferenceOpenHashMap();
    }
}

