/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.config;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class CustomConfigScreen
extends Screen {
    protected final Screen lastScreen;
    private OptionsList list;

    public CustomConfigScreen(Screen lastScreen, String title) {
        super((Component)Component.m_237115_((String)title));
        this.lastScreen = lastScreen;
    }

    public void m_7861_() {
        this.save();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public OptionsList getOptions() {
        return this.list;
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.m_7787_((GuiEventListener)this.list);
        this.createFooter();
        this.initialize();
    }

    public abstract void initialize();

    public abstract void reset();

    public abstract void save();

    protected void createFooter() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, (Button.OnPress)new Button.OnPress(){

            public void m_93750_(Button button) {
                CustomConfigScreen.this.m_7379_();
            }
        }).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 27).m_253046_(200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"controls.reset"), (Button.OnPress)new Button.OnPress(){

            public void m_93750_(Button button) {
                CustomConfigScreen.this.reset();
                CustomConfigScreen.this.m_6574_(CustomConfigScreen.this.f_96541_, CustomConfigScreen.this.f_96543_, CustomConfigScreen.this.f_96544_);
            }
        }).m_252794_(this.f_96543_ / 2 + 110, this.f_96544_ - 27).m_253046_(60, 20).m_253136_());
        this.m_142416_((GuiEventListener)new PlainTextButton(5, 5, 400, 20, (Component)Component.m_237113_((String)"Enjoying the mod? Consider supporting the developer!"), new Button.OnPress(){

            public void m_93750_(Button button) {
                Util.m_137581_().m_137646_("https://tr7zw.dev/donate/");
            }
        }, this.f_96541_.f_91062_));
    }

    public void m_86412_(PoseStack poseStack, int i, int j, float f) {
        this.m_7333_(poseStack);
        this.list.m_86412_(poseStack, i, j, f);
        CustomConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_86412_(poseStack, i, j, f);
    }

    private <T> OptionInstance.TooltipSupplier<T> getOptionalTooltip(final String translationKey) {
        return new OptionInstance.TooltipSupplier<T>(){

            public Tooltip m_257630_(T param1t) {
                MutableComponent comp;
                String key = translationKey + ".tooltip";
                if (key.equals((comp = Component.m_237115_((String)key)).getString())) {
                    return null;
                }
                return Tooltip.m_257550_((Component)comp);
            }
        };
    }

    public OptionInstance<Boolean> getBooleanOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return OptionInstance.m_257874_((String)translationKey, this.getOptionalTooltip(translationKey), (boolean)current.get(), update);
    }

    public OptionInstance<Boolean> getOnOffOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return this.getBooleanOption(translationKey, current, update);
    }

    public OptionInstance<Double> getDoubleOption(String translationKey, float min, float max, float steps, Supplier<Double> current, Consumer<Double> update) {
        Double sliderValue = (current.get() - (double)min) / (double)(max - min);
        return new OptionInstance(translationKey, this.getOptionalTooltip(translationKey), (comp, d) -> {
            double lvt_4_1_ = (double)min + d * (double)(max - min);
            lvt_4_1_ = (int)(lvt_4_1_ / (double)steps);
            return comp.m_6881_().m_130946_(": " + CustomConfigScreen.round(lvt_4_1_ *= (double)steps, 3));
        }, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, Codec.doubleRange((double)min, (double)max), (Object)sliderValue, d -> {
            double lvt_4_1_ = (double)min + d * (double)(max - min);
            lvt_4_1_ = (int)(lvt_4_1_ / (double)steps);
            update.accept(lvt_4_1_ *= (double)steps);
        });
    }

    public OptionInstance<Integer> getIntOption(String translationKey, int min, int max, Supplier<Integer> current, Consumer<Integer> update) {
        return new OptionInstance(translationKey, this.getOptionalTooltip(translationKey), (comp, d) -> comp.m_6881_().m_130946_(": " + d), (OptionInstance.ValueSet)new OptionInstance.IntRange(min, max), (Object)current.get(), d -> update.accept((Integer)d));
    }

    public <T extends Enum> OptionInstance<T> getEnumOption(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<T> update) {
        HashMap mapping = new HashMap();
        Arrays.asList((Enum[])targetEnum.getEnumConstants()).forEach(t -> mapping.put(t.name(), t));
        return new OptionInstance(translationKey, this.getOptionalTooltip(translationKey), (comp, t) -> Component.m_237115_((String)(translationKey + "." + t.name())), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList((Enum[])targetEnum.getEnumConstants()), Codec.STRING.xmap(s -> (Enum)mapping.get(s), e -> e.name())), (Object)((Enum)current.get()), update);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

