/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.gui.BasicUiElement;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.StringUtil;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.client.gui.Textures;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.PlatformDataSet;
import shetiphian.platforms.common.network.NetworkHandler;
import shetiphian.platforms.common.network.PacketWrenchEdit;

@OnlyIn(value=Dist.CLIENT)
public class GuiWrench
extends Screen {
    private final String TEXT_APPLY = I18n.m_118938_((String)"gui.platforms.wrench.edit.apply", (Object[])new Object[0]);
    private final String TEXT_APPLY_INFO = I18n.m_118938_((String)"gui.platforms.wrench.edit.apply.info", (Object[])new Object[0]);
    private final String TEXT_REMOVE_INFO = I18n.m_118938_((String)"gui.platforms.wrench.edit.remove.info", (Object[])new Object[0]);
    private final String TEXT_PLACE_INFO = I18n.m_118938_((String)"gui.platforms.wrench.edit.place.info", (Object[])new Object[0]);
    private final String TEXT_REVERT = I18n.m_118938_((String)"gui.platforms.wrench.edit.revert", (Object[])new Object[0]);
    private final String TEXT_DIRECTION = I18n.m_118938_((String)"gui.platforms.wrench.edit.direction", (Object[])new Object[0]);
    private final Map<EnumPlatformType, PlatformDataSet> presets;
    private final Set<BlockPos> posEditBlocks;
    private final Set<BlockPos> posPlaceBlocks;
    private final EnumPlatformType[] keySet;
    private int guiLeft;
    private final int[] sectionY = new int[4];
    private final List<BasicUiElement> elements = new ArrayList<BasicUiElement>();
    private final int scrollTabs = 5;
    private int firstTab = 0;
    private int activeTab;
    private final List<ItemStack> subTypeStacks = new ArrayList<ItemStack>();
    private final List<ItemStack> variantStacks = new ArrayList<ItemStack>();
    private String lastToolTip;
    private int countToolTip;
    private int yTooltip;
    private final String[] DIRECTION_HEADERS = new String[]{"N", "E", "S", "W"};

    public GuiWrench(Map<EnumPlatformType, PlatformDataSet> presets, Set<BlockPos> posEditBlocks, Set<BlockPos> posPlaceBlocks) {
        super((Component)Component.m_237119_());
        this.presets = presets;
        this.posEditBlocks = posEditBlocks;
        this.posPlaceBlocks = posPlaceBlocks;
        this.keySet = (EnumPlatformType[])presets.keySet().stream().sorted().toArray(EnumPlatformType[]::new);
    }

    protected void m_7856_() {
        int index;
        EnumPlatformType type;
        boolean isWalkway;
        super.m_7856_();
        this.m_169413_();
        this.elements.clear();
        this.sectionY[3] = 0;
        this.sectionY[2] = 0;
        this.sectionY[1] = 0;
        this.sectionY[0] = 0;
        int ySize = 51;
        if (this.presets.size() > 1) {
            ySize += 12;
            this.sectionY[0] = 12;
        }
        boolean bl = isWalkway = (type = this.keySet[this.activeTab]) == EnumPlatformType.FLAT || type == EnumPlatformType.FLOOR;
        if (type != EnumPlatformType.FRAME) {
            this.sectionY[1] = ySize;
            this.sectionY[2] = ySize += 24;
        }
        if (type.hasAlternatives()) {
            ySize += 24;
        } else if (isWalkway) {
            ySize += 96;
        }
        this.sectionY[3] = ySize;
        this.guiLeft = (this.f_96543_ - 128) / 2;
        int guiTop = (this.f_96544_ - (ySize += 7)) / 2;
        this.sectionY[0] = this.sectionY[0] + guiTop;
        this.sectionY[1] = this.sectionY[1] + guiTop;
        this.sectionY[2] = this.sectionY[2] + guiTop;
        this.sectionY[3] = this.sectionY[3] + guiTop;
        this.yTooltip = guiTop + ySize + 10;
        PlatformDataSet preset = this.presets.get((Object)type);
        if (preset == null) {
            Platforms.LOGGER.error("Data missing for Wrench GUI; closing to prevent crash");
            this.m_7379_();
            return;
        }
        ResourceLocation texture = Textures.WRENCH_EDIT.get();
        if (this.keySet.length > 1) {
            ArrayList<TabButton> tabs = new ArrayList<TabButton>();
            boolean shift = this.keySet.length > this.scrollTabs + 1;
            for (index = 0; index < this.keySet.length; ++index) {
                Enum[] platformType = this.keySet[index];
                tabs.add(new TabButton(this, index, this.guiLeft + 10 + (index - this.firstTab) * 18 + (shift ? 9 : 0), guiTop, this.presets.get(platformType), shift, texture));
            }
            tabs.forEach(x$0 -> {
                TabButton cfr_ignored_0 = (TabButton)this.m_142416_((GuiEventListener)x$0);
            });
            if (shift) {
                UiElement[] scroll;
                scroll = new UiElement[]{new UiElement(this.guiLeft + 1, guiTop, 18, 18, 220, 170, 220, 170, "left", "", () -> {
                    if (this.firstTab > 0) {
                        this.firstTab -= this.scrollTabs;
                        tabs.forEach(tabButton -> tabButton.shift(18 * this.scrollTabs));
                    }
                    scroll[0].visible = this.firstTab > 0;
                    scroll[1].visible = true;
                }), new UiElement(this.guiLeft + 109, guiTop, 18, 18, 238, 170, 238, 170, "right", "", () -> {
                    if (this.firstTab + this.scrollTabs < this.keySet.length) {
                        this.firstTab += this.scrollTabs;
                        tabs.forEach(tabButton -> tabButton.shift(-18 * this.scrollTabs));
                    }
                    scroll[0].visible = true;
                    scroll[1].visible = this.firstTab + this.scrollTabs < this.keySet.length;
                })};
                scroll[0].visible = this.firstTab > 0;
                scroll[1].visible = this.firstTab + this.scrollTabs < this.keySet.length;
                this.elements.add(scroll[0]);
                this.elements.add(scroll[1]);
            }
        }
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 57, this.sectionY[0] + 11, 56, 16, texture, 200, 224, 200, 240, 200, 224, this.TEXT_APPLY_INFO).setText(this.TEXT_APPLY).setPress(button -> this.applyChanges()));
        this.m_142416_((GuiEventListener)new Toggle(this.guiLeft + 58, this.sectionY[0] + 35, 24, 12, texture, 208, 200, 208, 212, 208, 188, preset.toRemove, this.TEXT_REMOVE_INFO).setPress(button -> {
            preset.toRemove = ((Toggle)button).toggle();
        }));
        this.m_142416_((GuiEventListener)new Toggle(this.guiLeft + 88, this.sectionY[0] + 35, 24, 12, texture, 232, 200, 232, 212, 232, 188, preset.toPlace, this.TEXT_PLACE_INFO).setPress(button -> {
            if (((Toggle)button).toggle()) {
                this.presets.values().forEach(platformDataSet -> {
                    platformDataSet.toPlace = platformDataSet.equals(preset);
                });
            } else {
                preset.toPlace = false;
            }
        }));
        this.elements.add(new UiElement(this.guiLeft + 7, this.sectionY[0] + 7, 12, 12, 184, 188, 196, 188, "revert", this.TEXT_REVERT, () -> {
            preset.reset();
            this.m_7856_();
        }));
        this.elements.add(new UiDirection(this.guiLeft + 17, this.sectionY[0] + 17, 24, 12, "direction:north", this.TEXT_DIRECTION, preset, direction -> {
            this.setDirection(preset, direction.m_7912_());
            return true;
        }));
        this.setDirection(preset, null);
        this.subTypeStacks.clear();
        this.variantStacks.clear();
        if (type != EnumPlatformType.FRAME) {
            boolean isIncline = type.isIncline();
            int left = this.guiLeft + 11 + (isWalkway ? 18 : (isIncline ? 9 : 0));
            index = 0;
            for (EnumSubType enumSubType : EnumSubType.getSimpleValues()) {
                boolean skip;
                boolean bl2 = skip = isWalkway && (enumSubType == EnumSubType.RIGHT || enumSubType == EnumSubType.LEFT) || isIncline && enumSubType == EnumSubType.EDGE;
                if (skip) continue;
                ItemStack stack = preset.itemStack.m_41777_();
                ItemBlockPlatform.setSubType(stack, enumSubType);
                this.subTypeStacks.add(stack);
                String name = enumSubType.m_7912_();
                this.elements.add(new UiSelect(left + 18 * index, this.sectionY[1] + 4, "subtype:" + name, () -> this.setSubType(preset, name)));
                ++index;
            }
            this.setSubType(preset, null);
            if (type.hasAlternatives()) {
                left = this.guiLeft + 11 + (6 - type.getAlternatives().length) * 9;
                index = 0;
                for (Enum enum_ : type.getAlternatives()) {
                    String name = ((EnumPlatformType)enum_).m_7912_();
                    this.elements.add(new UiSelect(left + 18 * index, this.sectionY[2] + 4, "variant:" + name, () -> this.setVariant(preset, name)));
                    ++index;
                }
                this.setVariant(preset, null);
            } else if (isWalkway) {
                String[] names = new String[]{"n", "e", "s", "w"};
                for (int row = 0; row < 4; ++row) {
                    for (int col = 0; col < 4; ++col) {
                        String string = names[row] + names[col];
                        this.elements.add(new UiSelect(this.guiLeft + 37 + 18 * col, this.sectionY[2] + 22 + 18 * row, "texture:" + string, () -> this.setTextureVariant(preset, name)));
                    }
                }
                this.setTextureVariant(preset, null);
            }
        }
    }

    private void setDirection(PlatformDataSet preset, String direction) {
        if (direction != null) {
            preset.setDirection(direction);
            this.elements.forEach(element -> {
                if (element.name.equals("revert")) {
                    element.visible = element.enabled = preset.hasChanges();
                }
            });
        }
    }

    private void setSubType(PlatformDataSet preset, String subType) {
        String texture;
        if (subType != null) {
            preset.setSubType(subType);
        }
        this.updateElements(preset, "subtype:", preset.getSubType(), this.elements);
        if (preset.isWalkway() && preset.isEdge() && (texture = preset.getVariant()).charAt(0) != texture.charAt(1)) {
            texture = String.format("%c%c", Character.valueOf(texture.charAt(0)), Character.valueOf(texture.charAt(0)));
            this.setTextureVariant(preset, texture);
        }
        if (preset.hasAlternatives()) {
            this.updateStyleStacks(preset);
        }
    }

    private void setVariant(PlatformDataSet preset, String variant) {
        if (variant != null) {
            preset.setVariant(variant);
        }
        this.updateElements(preset, "variant:", preset.getVariant(), this.elements);
    }

    private void setTextureVariant(PlatformDataSet preset, String texture) {
        if (texture != null) {
            if (preset.isEdge() && texture.charAt(0) != texture.charAt(1)) {
                return;
            }
            preset.setVariant(texture);
        }
        this.updateElements(preset, "texture:", preset.getVariant(), this.elements);
    }

    private void updateElements(PlatformDataSet preset, String key, String name, List<BasicUiElement> elements) {
        elements.forEach(element -> {
            if (element.name.startsWith(key)) {
                element.visible = element.name.endsWith(name);
            }
            if (element.name.equals("revert")) {
                element.visible = element.enabled = preset.hasChanges();
            }
        });
    }

    private void updateStyleStacks(PlatformDataSet preset) {
        this.variantStacks.clear();
        EnumSubType subType = EnumSubType.SIMPLE_LOOKUP.get(preset.getSubType());
        for (EnumPlatformType variant : preset.getAlternatives()) {
            ItemStack stack = ItemBlockPlatform.createStack(variant, preset.itemStack);
            if (subType != null) {
                ItemBlockPlatform.setSubType(stack, subType);
            }
            this.variantStacks.add(stack);
        }
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        GuiHelper.setRenderSystem((ResourceLocation)Textures.WRENCH_EDIT.get());
        EnumPlatformType type = this.keySet[this.activeTab];
        if (type == EnumPlatformType.FRAME) {
            GuiWrench.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.sectionY[0], (int)0, (int)0, (int)128, (int)58);
        } else {
            GuiWrench.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.sectionY[0], (int)0, (int)0, (int)128, (int)51);
            if (type.isAddon()) {
                GuiWrench.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.sectionY[1], (int)0, (int)58, (int)128, (int)31);
            } else {
                GuiWrench.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.sectionY[1], (int)0, (int)58, (int)128, (int)24);
            }
            if (type.hasAlternatives()) {
                GuiWrench.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.sectionY[2], (int)0, (int)89, (int)128, (int)31);
            } else if (type == EnumPlatformType.FLAT || type == EnumPlatformType.FLOOR) {
                GuiWrench.m_93228_((PoseStack)matrixStack, (int)this.guiLeft, (int)this.sectionY[2], (int)0, (int)120, (int)128, (int)103);
            }
        }
        GuiHelper.resetRenderSystem();
        this.elements.forEach(element -> element.render(matrixStack, mouseX, mouseY));
        this.elements.forEach(element -> {
            if (element instanceof UiSelect) {
                ((UiSelect)((Object)element)).renderFrame(matrixStack);
            }
        });
        this.f_169369_.forEach(widget -> widget.m_86412_(matrixStack, mouseX, mouseY, partialTicks));
        PlatformDataSet preset = this.presets.get((Object)type);
        for (int index = 0; index < 3; ++index) {
            if (!preset.isChanged(index)) continue;
            GuiHelper.drawLine((PoseStack)matrixStack, (double)(this.guiLeft + 7), (double)(this.sectionY[index] + (index == 0 ? 13 : 6)), (double)(this.guiLeft + 7), (double)(this.sectionY[index + 1] - 6), (float)1.0f, (int)-13158601);
        }
        if (type != EnumPlatformType.FRAME) {
            int index;
            int x = this.guiLeft + 11 + (6 - this.subTypeStacks.size()) * 9;
            for (index = 0; index < this.subTypeStacks.size(); ++index) {
                this.f_96542_.m_274369_(matrixStack, this.subTypeStacks.get(index), x + index * 18, this.sectionY[1] + 4);
            }
            if (type.hasAlternatives()) {
                x = this.guiLeft + 11 + (6 - this.variantStacks.size()) * 9;
                for (index = 0; index < this.variantStacks.size(); ++index) {
                    this.f_96542_.m_274369_(matrixStack, this.variantStacks.get(index), x + index * 18, this.sectionY[2] + 4);
                }
            }
            if (preset.isWalkway()) {
                int row;
                int col;
                GuiHelper.setRenderSystem((ResourceLocation)preset.texture);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
                renderer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
                int rx = this.guiLeft + 37;
                int ry = this.sectionY[2] + 4;
                int[][] u = new int[][]{{0, 1, 1, 0}, {1, 1, 0, 0}, {1, 0, 0, 1}, {0, 0, 1, 1}};
                int[][] v = new int[][]{{1, 1, 0, 0}, {1, 0, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 0}};
                for (col = 0; col < 4; ++col) {
                    for (row = 0; row < 5; ++row) {
                        renderer.m_5483_((double)(rx + col * 18), (double)(ry + row * 18 + 16), 1.0).m_7421_((float)u[col][0], (float)v[col][0]).m_5752_();
                        renderer.m_5483_((double)(rx + col * 18 + 16), (double)(ry + row * 18 + 16), 1.0).m_7421_((float)u[col][1], (float)v[col][1]).m_5752_();
                        renderer.m_5483_((double)(rx + col * 18 + 16), (double)(ry + row * 18), 1.0).m_7421_((float)u[col][2], (float)v[col][2]).m_5752_();
                    }
                }
                rx -= 18;
                ry += 18;
                for (col = 0; col < 5; ++col) {
                    for (row = 0; row < 4; ++row) {
                        renderer.m_5483_((double)(rx + col * 18), (double)(ry + row * 18 + 16), 1.0).m_7421_((float)u[row][0], (float)v[row][0]).m_5752_();
                        renderer.m_5483_((double)(rx + col * 18 + 16), (double)(ry + row * 18), 1.0).m_7421_((float)u[row][2], (float)v[row][2]).m_5752_();
                        renderer.m_5483_((double)(rx + col * 18), (double)(ry + row * 18), 1.0).m_7421_((float)u[row][3], (float)v[row][3]).m_5752_();
                    }
                }
                GuiHelper.resetRenderSystem();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
                RenderSystem.m_69478_();
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                renderer = Tesselator.m_85913_().m_85915_();
                renderer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                ry -= 18;
                for (col = 0; col < 5; ++col) {
                    for (row = 0; row < 5; ++row) {
                        if (row == col) continue;
                        renderer.m_5483_((double)(rx + col * 18), (double)(ry + row * 18 + 16), 1.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
                        renderer.m_5483_((double)(rx + col * 18 + 16), (double)(ry + row * 18), 1.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
                    }
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
                RenderSystem.m_69461_();
                if (preset.isEdge()) {
                    GuiHelper.setRenderSystem((ResourceLocation)Textures.WRENCH_EDIT.get());
                    rx += 18;
                    ry += 18;
                    for (col = 0; col < 4; ++col) {
                        for (row = 0; row < 4; ++row) {
                            if (row == col) continue;
                            GuiWrench.m_93228_((PoseStack)matrixStack, (int)(rx + col * 18 + 2), (int)(ry + row * 18 + 2), (int)184, (int)224, (int)12, (int)12);
                        }
                    }
                    GuiHelper.resetRenderSystem();
                }
                rx = this.guiLeft + 27;
                ry = this.sectionY[2] + 8;
                GuiWrench.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"\u2193\u2192", (int)rx, (int)ry, (int)-1);
                this.renderScaledStrings(matrixStack, 0.6f, 1.67f, this.DIRECTION_HEADERS, rx += 3, (ry += 5) + 18, rx, ry + 36, rx, ry + 54, rx, ry + 72);
                this.renderScaledStrings(matrixStack, 0.6f, 1.67f, this.DIRECTION_HEADERS, (rx -= 7) + 18, ry -= 7, rx + 36, ry, rx + 54, ry, rx + 72, ry);
            }
        }
        this.renderScaledStrings(matrixStack, 0.6f, 1.67f, this.DIRECTION_HEADERS, this.guiLeft + 29, this.sectionY[0] + 10, this.guiLeft + 45, this.sectionY[0] + 27, this.guiLeft + 29, this.sectionY[0] + 43, this.guiLeft + 12, this.sectionY[0] + 27);
        AtomicReference<String> fetch = new AtomicReference<String>("");
        this.elements.forEach(element -> {
            if (element.visible && element.isMouseOver((double)mouseX, (double)mouseY)) {
                fetch.set(element.tooltip);
            }
        });
        this.f_169369_.forEach(renderable -> {
            AbstractWidget widget;
            if (renderable instanceof AbstractWidget && (widget = (AbstractWidget)renderable).m_5953_((double)mouseX, (double)mouseY)) {
                fetch.set(widget instanceof Button ? ((Button)widget).tooltip : widget.m_6035_().getString());
            }
        });
        String tooltip = fetch.get();
        if (!Strings.isNullOrEmpty((String)tooltip)) {
            if (!tooltip.equals(this.lastToolTip)) {
                this.lastToolTip = tooltip;
                this.countToolTip = 0;
            } else {
                ++this.countToolTip;
            }
            if (this.countToolTip >= 40) {
                this.countToolTip = 40;
                ArrayList lines = new ArrayList();
                StringUtil.multiLineTooltip((String)tooltip, lines);
                this.m_169388_(matrixStack, lines, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private void renderScaledStrings(PoseStack matrixStack, float scale, float unscale, String[] lines, int ... xys) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, scale);
        int pointer = 0;
        for (String line : lines) {
            if (pointer + 2 <= xys.length) {
                GuiWrench.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)line, (int)Math.round((float)xys[pointer] * unscale), (int)Math.round((float)xys[pointer + 1] * unscale), (int)-1);
                pointer += 2;
                continue;
            }
            GuiWrench.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)line, (int)0, (int)0, (int)-1);
        }
        matrixStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (BasicUiElement element : this.elements) {
            if (!element.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void applyChanges() {
        boolean[] actions = new boolean[]{false, false};
        CompoundTag allChanges = new CompoundTag();
        this.presets.forEach((type, data) -> {
            CompoundTag changes;
            if (data.toRemove || data.hasChanges()) {
                actions[0] = true;
            }
            if (!data.toRemove && data.toPlace) {
                actions[1] = true;
            }
            if (!(changes = data.write(new CompoundTag())).m_128456_()) {
                allChanges.m_128365_(type.m_7912_(), (Tag)changes);
            }
        });
        if (!allChanges.m_128456_()) {
            NetworkHandler.sendToServer(new PacketWrenchEdit(allChanges, actions[0] ? this.posEditBlocks : Collections.emptySet(), actions[1] ? this.posPlaceBlocks : Collections.emptySet()));
            this.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static class TabButton
    extends AbstractButton {
        private final GuiWrench parent;
        private final int index;
        private final PlatformDataSet preset;
        private final ResourceLocation texture;

        public TabButton(GuiWrench parent, int index, int x, int y, PlatformDataSet preset, boolean shifted, ResourceLocation texture) {
            super(x, y, 18, 15, (Component)Component.m_237115_((String)preset.itemStack.m_41778_()));
            this.parent = parent;
            this.index = index;
            this.preset = preset;
            this.texture = texture;
            this.f_93624_ = !shifted || this.index >= this.parent.firstTab && this.index < this.parent.firstTab + this.parent.scrollTabs;
        }

        public void shift(int value) {
            this.m_252865_(this.m_252754_() + value);
            this.f_93624_ = this.index >= this.parent.firstTab && this.index < this.parent.firstTab + this.parent.scrollTabs;
        }

        public void m_5691_() {
            this.parent.activeTab = this.index;
            this.parent.m_7856_();
        }

        public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                int x = this.m_252754_();
                int y = this.m_252907_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
                TabButton.m_93228_((PoseStack)matrixStack, (int)x, (int)y, (int)(this.index == this.parent.activeTab ? 184 : 202), (int)170, (int)18, (int)18);
                PoseStack posestack = RenderSystem.m_157191_();
                posestack.m_85836_();
                posestack.m_85841_(0.6f, 0.6f, 0.6f);
                this.parent.f_96542_.m_274369_(matrixStack, this.preset.itemStack, Math.round((float)(x + 3) * 1.67f), Math.round((float)(y + 5) * 1.67f));
                posestack.m_85849_();
                RenderSystem.m_157182_();
                if (this.preset.toPlace || this.preset.toRemove || this.preset.hasChanges()) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
                    if (this.preset.hasChanges()) {
                        GuiHelper.drawTextureScaled((PoseStack)matrixStack, (double)(x + 3), (double)(y - 3), (int)172, (int)224, (int)12, (int)12, (double)0.5);
                    }
                    if (this.preset.toPlace || this.preset.toRemove) {
                        int pt = this.preset.toRemove ? (this.preset.toPlace ? 200 : 212) : 188;
                        GuiHelper.drawTextureScaled((PoseStack)matrixStack, (double)(x + 9), (double)(y - 3), (int)172, (int)pt, (int)12, (int)12, (double)0.5);
                    }
                }
            }
        }

        protected void m_168797_(NarrationElementOutput narration) {
        }
    }

    private static class UiElement
    extends BasicUiElement {
        public UiElement(int x, int y, int width, int height, int nU, int nV, int hU, int hV, String name, String tooltip, BasicUiElement.SimpleAction action) {
            super(0, 0, width, height, nU, nV, hU, hV, 1.0f, name, tooltip, action);
            this.setScreenOffset(x, y);
        }
    }

    private static class Button
    extends ButtonIcon {
        public final String tooltip;
        private final Component message;

        public Button(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int nU, int nV, int hU, int hV, int pU, int pV, String tooltip) {
            this(posX, posY, sizeX, sizeY, texture, new int[]{nU, nV}, new int[]{hU, hV}, new int[]{pU, pV}, tooltip);
        }

        public Button(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int[] normal, int[] hover, int[] pressed, String tooltip) {
            super(posX, posY, sizeX, sizeY, texture, normal, hover, pressed);
            this.tooltip = tooltip;
            this.message = Component.m_237115_((String)tooltip);
        }

        public Component m_6035_() {
            return this.message;
        }
    }

    private static class Toggle
    extends Button {
        private final int[] normal;
        private final int[] pressed;
        private final int[] original;
        private boolean toggled;

        public Toggle(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int nU, int nV, int hU, int hV, int pU, int pV, boolean toggled, String tooltip) {
            this(posX, posY, sizeX, sizeY, texture, new int[]{nU, nV}, new int[]{hU, hV}, new int[]{pU, pV}, toggled, tooltip);
        }

        private Toggle(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int[] normal, int[] hover, int[] pressed, boolean toggled, String tooltip) {
            super(posX, posY, sizeX, sizeY, texture, normal, hover, pressed, tooltip);
            this.original = (int[])normal.clone();
            this.normal = normal;
            this.pressed = pressed;
            if (toggled) {
                this.toggle();
            }
        }

        public boolean isToggled() {
            return this.toggled;
        }

        public boolean toggle() {
            this.toggled = !this.toggled;
            this.normal[0] = this.toggled ? this.pressed[0] : this.original[0];
            this.normal[1] = this.toggled ? this.pressed[1] : this.original[1];
            return this.toggled;
        }
    }

    private static class UiDirection
    extends UiElement {
        private final PlatformDataSet preset;
        private final int sizeButton;
        private final Predicate<Direction> action;

        public UiDirection(int x, int y, int size, int sizeButton, String name, String tooltip, PlatformDataSet preset, Predicate<Direction> action) {
            super(x, y, size, size, 0, 0, 0, 0, name, tooltip, null);
            this.preset = preset;
            this.sizeButton = sizeButton;
            this.action = action;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.enabled && this.isMouseOver(mouseX, mouseY)) {
                double localX = mouseX - (double)this.x;
                double localY = mouseY - (double)this.y;
                int btn = this.sizeButton / 2;
                int cX = this.width / 2;
                int cY = this.height / 2;
                if (localX >= Math.max((double)(cX - btn), localY) && localX < Math.min((double)this.width - localY, (double)(cX + btn)) && localY >= 0.0 && localY < (double)cY) {
                    return this.action.test(Direction.NORTH);
                }
                if (localX >= Math.max((double)(cX - btn), (double)this.width - localY) && localX < Math.min(localY, (double)(cX + btn)) && localY >= (double)cY && localY < (double)this.height) {
                    return this.action.test(Direction.SOUTH);
                }
                if (localX >= (double)cX && localX < (double)this.width && localY >= Math.max((double)(cY - btn), (double)this.height - localX) && localY < Math.min(localX, (double)(cY + btn))) {
                    return this.action.test(Direction.EAST);
                }
                if (localX >= 0.0 && localX < (double)cX && localY >= Math.max((double)(cY - btn), localX) && localY < Math.min((double)this.height - localX, (double)(cY + btn))) {
                    return this.action.test(Direction.WEST);
                }
            }
            return false;
        }

        public void render(PoseStack matrixStack, int mouseX, int mouseY) {
            if (this.visible) {
                switch (this.preset.getDirection()) {
                    case "north": {
                        GuiComponent.m_93228_((PoseStack)matrixStack, (int)(this.x + 6), (int)this.y, (int)184, (int)200, (int)this.sizeButton, (int)this.sizeButton);
                        break;
                    }
                    case "south": {
                        GuiComponent.m_93228_((PoseStack)matrixStack, (int)(this.x + 6), (int)(this.y + 12), (int)196, (int)200, (int)this.sizeButton, (int)this.sizeButton);
                        break;
                    }
                    case "east": {
                        GuiComponent.m_93228_((PoseStack)matrixStack, (int)(this.x + 12), (int)(this.y + 6), (int)184, (int)212, (int)this.sizeButton, (int)this.sizeButton);
                        break;
                    }
                    case "west": {
                        GuiComponent.m_93228_((PoseStack)matrixStack, (int)this.x, (int)(this.y + 6), (int)196, (int)212, (int)this.sizeButton, (int)this.sizeButton);
                    }
                }
            }
        }
    }

    private static class UiSelect
    extends UiElement {
        public UiSelect(int x, int y, String name, BasicUiElement.SimpleAction action) {
            super(x, y, 16, 16, 162, 238, 180, 236, name, "", action);
        }

        public void render(PoseStack matrixStack, int mouseX, int mouseY) {
            GuiComponent.m_93228_((PoseStack)matrixStack, (int)(this.x - 1), (int)(this.y - 1), (int)this.normal[0], (int)this.normal[1], (int)(this.width + 2), (int)(this.height + 2));
        }

        public void renderFrame(PoseStack matrixStack) {
            if (this.visible) {
                GuiComponent.m_93228_((PoseStack)matrixStack, (int)(this.x - 2), (int)(this.y - 2), (int)this.hover[0], (int)this.hover[1], (int)(this.width + 4), (int)(this.height + 4));
            }
        }
    }
}

