/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.slf4j.Logger;
import shetiphian.core.client.model.AbstractModelCacheBuilder;
import shetiphian.core.client.model.IPartData;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.client.model.Parts;

@OnlyIn(value=Dist.CLIENT)
public class CacheBuilder
extends AbstractModelCacheBuilder {
    public static CacheBuilder INSTANCE = new CacheBuilder(Platforms.LOGGER);
    private final Table<BlockState, CompoundTag, HashMap<RenderType, List<BakedModel>>> MODEL_CACHE = HashBasedTable.create();

    public CacheBuilder(Logger logger) {
        super(logger);
    }

    protected void onReload() {
        CacheBuilder.INSTANCE.MODEL_CACHE.clear();
    }

    static void preload() {
        for (IPartData partData : Parts.MODELS) {
            CacheBuilder.INSTANCE.BAKERY.m_245361_(partData.getLocation());
        }
    }

    public void preBakeSetup(ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter) {
        super.preBakeSetup(bakery, spriteGetter);
        CacheBuilder.preload();
    }

    public static BakedModel get(String part, String key, Direction facing, String particle) {
        return INSTANCE.get(part, key, facing, particle, Parts.MODELS);
    }

    protected ImmutableMap<String, String> setTextures(IPartData iPartData, String texture, String particle) {
        return new ImmutableMap.Builder().put((Object)"texture", (Object)texture).put((Object)"particle", (Object)particle).build();
    }

    protected List<BakedModel> getOrBuildModelList(BlockState state, ModelData data, RenderType layer, Supplier<List<BakedModel>> builder) {
        List modelList;
        CompoundTag nbtTag = data.has(ModelProperties.NBTProperty) ? (CompoundTag)data.get(ModelProperties.NBTProperty) : null;
        HashMap map = null;
        if (nbtTag == null) {
            nbtTag = new CompoundTag();
        }
        if (this.MODEL_CACHE.contains((Object)state, (Object)nbtTag)) {
            map = (HashMap)this.MODEL_CACHE.get((Object)state, (Object)nbtTag);
        }
        if (map == null) {
            map = new HashMap();
            this.MODEL_CACHE.put((Object)state, (Object)nbtTag, (Object)map);
        }
        if (map.containsKey(layer)) {
            modelList = (List)map.get(layer);
        } else {
            modelList = builder.get();
            map.put(layer, modelList.isEmpty() ? Collections.emptyList() : modelList);
        }
        return modelList;
    }
}

