/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.Function;
import shetiphian.core.common.network.PacketBase;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class PacketWrenchEdit
extends PacketBase {
    private final CompoundTag changes;
    private final Set<BlockPos> edit;
    private final Set<BlockPos> place;
    private int cachedSlot = -1;

    public PacketWrenchEdit(CompoundTag changes, Set<BlockPos> edit, Set<BlockPos> place) {
        this.changes = changes;
        this.edit = edit;
        this.place = place;
    }

    public static void writeData(PacketWrenchEdit packet, FriendlyByteBuf buffer) {
        buffer.m_130079_(packet.changes);
        buffer.m_130130_(packet.edit.size());
        packet.edit.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130064_(arg_0));
        buffer.m_130130_(packet.place.size());
        packet.place.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130064_(arg_0));
    }

    public static PacketWrenchEdit readData(FriendlyByteBuf buffer) {
        return new PacketWrenchEdit(buffer.m_130260_(), PacketWrenchEdit.readSet(buffer), PacketWrenchEdit.readSet(buffer));
    }

    private static Set<BlockPos> readSet(FriendlyByteBuf buffer) {
        int entries = buffer.m_130242_();
        if (entries > 0) {
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            for (int count = 0; count < entries; ++count) {
                set.add(buffer.m_130135_());
            }
            return set;
        }
        return Collections.emptySet();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClientSide(Player player) {
    }

    public void handleServerSide(Player player) {
        Level level = player.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        HashMap<String, List> map = new HashMap<String, List>();
        this.edit.forEach(pos -> {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof BlockPlatformBase) {
                String type = ((BlockPlatformBase)block).getPlatformType().m_7912_();
                if (map.containsKey(type)) {
                    ((List)map.get(type)).add(pos);
                } else {
                    ArrayList<BlockPos> list = new ArrayList<BlockPos>();
                    list.add((BlockPos)pos);
                    map.put(type, list);
                }
            }
        });
        ArrayList drops = new ArrayList();
        AtomicReference<ItemStack> placeStack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        AtomicReference<Object> placeState = new AtomicReference<Object>(null);
        map.forEach((type, listPos) -> {
            CompoundTag data = this.changes.m_128469_(type);
            if (!data.m_128456_()) {
                EnumSubType subType;
                Direction direction = data.m_128441_("direction") ? Direction.m_122407_((int)data.m_128445_("direction")) : null;
                EnumPlatformType platformType = data.m_128441_("type") ? EnumPlatformType.byIndex(data.m_128445_("type")) : null;
                EnumSubType enumSubType = subType = data.m_128441_("subtype") ? EnumSubType.byIndex(data.m_128445_("subtype")) : null;
                if (data.m_128471_("remove")) {
                    ItemStack stack = data.m_128441_("stack") ? ItemStack.m_41712_((CompoundTag)data.m_128469_("stack")) : ItemStack.f_41583_;
                    BlockState state = this.buildState(stack, direction, platformType, subType);
                    boolean place = data.m_128471_("place");
                    if (place) {
                        placeStack.set(stack);
                        placeState.set(state);
                    }
                    listPos.forEach(pos -> {
                        drops.addAll(Block.m_49869_((BlockState)world.m_8055_(pos), (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos)));
                        if (place && state != null) {
                            if (this.hasStack(player, stack)) {
                                BlockEntity tile;
                                BlockEntity original = world.m_7702_(pos);
                                if (world.m_7731_(pos, state, 11) && (tile = world.m_7702_(pos)) instanceof TileEntityPlatformBase) {
                                    ((TileEntityPlatformBase)tile).copySettingsFrom(original);
                                    ((TileEntityPlatformBase)tile).setTextureInfo((ItemStack)placeStack.get());
                                }
                            }
                        } else {
                            world.m_7471_(pos, false);
                        }
                    });
                } else {
                    if (platformType != null) {
                        listPos.forEach(pos -> {
                            BlockEntity tile;
                            BlockState state = world.m_8055_(pos);
                            ItemStack stack = state.getCloneItemStack(null, (BlockGetter)world, pos, player);
                            BlockEntity original = world.m_7702_(pos);
                            if (world.m_7731_(pos, this.buildState(state, direction, platformType, subType), 3) && (tile = world.m_7702_(pos)) instanceof TileEntityPlatformBase) {
                                ((TileEntityPlatformBase)tile).copySettingsFrom(original);
                                ((TileEntityPlatformBase)tile).setTextureInfo(stack);
                            }
                        });
                    }
                    listPos.forEach(pos -> world.m_7731_(pos, this.buildState(world.m_8055_(pos), direction, null, subType), 3));
                }
            }
        });
        if (!this.place.isEmpty()) {
            if (placeState.get() == null) {
                for (String key : this.changes.m_128431_()) {
                    EnumSubType subType;
                    EnumPlatformType platformType;
                    Direction direction;
                    BlockState state;
                    ItemStack stack2;
                    CompoundTag data = this.changes.m_128469_(key);
                    if (!data.m_128471_("place") || data.m_128471_("remove")) continue;
                    ItemStack itemStack = stack2 = data.m_128441_("stack") ? ItemStack.m_41712_((CompoundTag)data.m_128469_("stack")) : ItemStack.f_41583_;
                    if (stack2.m_41619_() || (state = this.buildState(stack2, direction = data.m_128441_("direction") ? Direction.m_122407_((int)data.m_128445_("direction")) : null, platformType = data.m_128441_("type") ? EnumPlatformType.byIndex(data.m_128445_("type")) : null, subType = data.m_128441_("subtype") ? EnumSubType.byIndex(data.m_128445_("subtype")) : null)) == null) break;
                    placeStack.set(stack2);
                    placeState.set(state);
                    break;
                }
            }
            if (placeState.get() != null) {
                this.place.forEach(pos -> {
                    if (this.hasStack(player, (ItemStack)placeStack.get())) {
                        world.m_7731_(pos, (BlockState)placeState.get(), 3);
                        BlockEntity tile = world.m_7702_(pos);
                        if (tile instanceof TileEntityPlatformBase) {
                            ((TileEntityPlatformBase)tile).setTextureInfo((ItemStack)placeStack.get());
                        }
                    }
                });
            }
        }
        if (!player.m_150110_().f_35937_) {
            drops.forEach(stack -> Function.giveItem((Player)player, (ItemStack)stack));
        }
    }

    private BlockState buildState(ItemStack stack, Direction direction, EnumPlatformType platformType, EnumSubType subType) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform) {
            return this.buildState(((ItemBlockPlatform)stack.m_41720_()).m_40614_().m_49966_(), direction, platformType, subType);
        }
        return null;
    }

    private BlockState buildState(BlockState state, Direction direction, EnumPlatformType platformType, EnumSubType subType) {
        BlockPlatformBase block;
        if (platformType != null && (block = Values.getPlatform(platformType)) != null) {
            BlockState build = block.m_49966_();
            try {
                for (Property property : state.m_61147_()) {
                    if (!build.m_61138_(property)) continue;
                    build = (BlockState)build.m_61124_(property, state.m_61143_(property));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            state = build;
        }
        if (direction != null && state.m_61138_((Property)BlockPlatformBase.FACING)) {
            state = (BlockState)state.m_61124_((Property)BlockPlatformBase.FACING, (Comparable)direction);
        }
        try {
            if (subType != null) {
                state = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    private boolean hasStack(Player player, ItemStack stack) {
        int slot;
        if (player.m_150110_().f_35937_) {
            return true;
        }
        if (this.cachedSlot > -1) {
            ItemStack stack2 = player.m_150109_().m_8020_(this.cachedSlot);
            if (stack2.m_41656_(stack)) {
                stack2.m_41774_(1);
                return true;
            }
            this.cachedSlot = -1;
        }
        if ((slot = player.m_150109_().m_36043_(stack)) > -1) {
            this.cachedSlot = slot;
            player.m_150109_().m_8020_(slot).m_41774_(1);
            return true;
        }
        return false;
    }
}

