/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.entity.DummyPlayer;
import de.maxhenkel.gravestone.gui.PageList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ObituaryScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("gravestone", "textures/gui/info.png");
    protected static final int TEXTURE_X = 163;
    protected static final int TEXTURE_Y = 165;
    protected static final int ITEM_OFFSET_LEFT = 40;
    protected static final int OFFSET_LEFT = 7;
    protected static final int OFFSET_RIGHT = 14;
    protected static final int ITEM_SIZE_OFFSET_LEFT = 15;
    private DummyPlayer player;
    private Death death;
    private Button buttonPrev;
    private Button buttonNext;
    private int page;
    private PageList pageList;
    private int guiLeft;
    private int guiTop;

    public ObituaryScreen(Death death) {
        super((Component)Component.m_237115_((String)"gui.obituary.title"));
        this.death = death;
        this.page = 0;
        this.pageList = new PageList(death.getAllItems(), this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 163) / 2;
        this.guiTop = (this.f_96544_ - 165) / 2;
        int left = (this.f_96543_ - 163) / 2;
        this.buttonPrev = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.gravestone.prev"), button -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.checkButtons();
        }).m_252987_(left, 190, 75, 20).m_253136_());
        this.buttonNext = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.gravestone.next"), button -> {
            ++this.page;
            if (this.page > this.pageList.getPages()) {
                this.page = this.pageList.getPages();
            }
            this.checkButtons();
        }).m_252987_(left + 163 - 75, 190, 75, 20).m_253136_());
        this.buttonPrev.f_93623_ = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.f_93623_ = false;
        }
    }

    protected void checkButtons() {
        this.buttonPrev.f_93623_ = this.page > 0;
        this.buttonNext.f_93623_ = this.page < this.pageList.getPages();
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        int left = (this.f_96543_ - 163) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        ObituaryScreen.m_93228_((PoseStack)matrixStack, (int)left, (int)20, (int)0, (int)0, (int)163, (int)165);
        if (this.page == 0) {
            this.drawFirstPage(matrixStack, mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(matrixStack, this.page - 1, mouseX, mouseY);
        }
    }

    public void drawFirstPage(PoseStack matrixStack, int mouseX, int mouseY) {
        this.drawCentered(matrixStack, this.f_96547_, Component.m_237115_((String)"gui.obituary.title").m_130940_(ChatFormatting.UNDERLINE), this.f_96543_ / 2, 30, ChatFormatting.BLACK.m_126665_());
        int height = 50;
        if (this.f_96541_.f_91066_.f_92125_) {
            this.drawLeft(matrixStack, Component.m_237115_((String)"gui.obituary.id").m_130946_(":").m_130940_(ChatFormatting.BLACK), height);
            this.drawRight(matrixStack, Component.m_237113_((String)this.death.getId().toString()).m_130940_(ChatFormatting.DARK_GRAY), height, 0.5f);
            height += 13;
        }
        this.drawLeft(matrixStack, Component.m_237115_((String)"gui.obituary.name").m_130946_(":").m_130940_(ChatFormatting.BLACK), height);
        this.drawRight(matrixStack, Component.m_237113_((String)this.death.getPlayerName()).m_130940_(ChatFormatting.DARK_GRAY), height);
        this.drawLeft(matrixStack, Component.m_237115_((String)"gui.obituary.dimension").m_130946_(":").m_130940_(ChatFormatting.BLACK), height += 13);
        this.drawRight(matrixStack, Component.m_237113_((String)this.death.getDimension().split(":")[1]).m_130940_(ChatFormatting.DARK_GRAY), height);
        this.drawLeft(matrixStack, Component.m_237115_((String)"gui.obituary.time").m_130946_(":").m_130940_(ChatFormatting.BLACK), height += 13);
        MutableComponent date = GraveUtils.getDate(this.death.getTimestamp());
        if (date != null) {
            this.drawRight(matrixStack, date.m_130940_(ChatFormatting.DARK_GRAY), height);
        } else {
            this.drawRight(matrixStack, Component.m_237113_((String)"N/A").m_130940_(ChatFormatting.DARK_GRAY), height);
        }
        this.drawLeft(matrixStack, Component.m_237115_((String)"gui.obituary.location").m_130946_(":").m_130940_(ChatFormatting.BLACK), height += 13);
        BlockPos pos = this.death.getBlockPos();
        this.drawRight(matrixStack, Component.m_237113_((String)("X: " + pos.m_123341_())).m_130940_(ChatFormatting.DARK_GRAY), height);
        this.drawRight(matrixStack, Component.m_237113_((String)("Y: " + pos.m_123342_())).m_130940_(ChatFormatting.DARK_GRAY), height += 13);
        this.drawRight(matrixStack, Component.m_237113_((String)("Z: " + pos.m_123343_())).m_130940_(ChatFormatting.DARK_GRAY), height += 13);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.player == null) {
            this.player = new DummyPlayer(this.f_96541_.f_91073_, new GameProfile(this.death.getPlayerUUID(), this.death.getPlayerName()), this.death.getEquipment(), this.death.getModel());
        }
        InventoryScreen.m_274545_((PoseStack)matrixStack, (int)(this.f_96543_ / 2), (int)170, (int)30, (float)(this.f_96543_ / 2 - mouseX), (float)(100 - mouseY), (LivingEntity)this.player);
        if (this.f_96541_.f_91066_.f_92125_ && mouseX >= this.guiLeft + 7 && mouseX <= this.guiLeft + 163 - 7 && mouseY >= 50) {
            Objects.requireNonNull(this.f_96547_);
            if (mouseY <= 50 + 9) {
                this.m_96617_(matrixStack, Collections.singletonList(Component.m_237115_((String)"gui.obituary.copy_id").m_7532_()), mouseX, mouseY);
            }
        }
    }

    public boolean m_6375_(double x, double y, int clickType) {
        if (this.f_96541_.f_91066_.f_92125_ && this.page == 0 && x >= (double)(this.guiLeft + 7) && x <= (double)(this.guiLeft + 163 - 7) && y >= 50.0) {
            Objects.requireNonNull(this.f_96547_);
            if (y <= (double)(50 + 9)) {
                this.f_96541_.f_91068_.m_90911_(this.death.getId().toString());
                MutableComponent deathID = ComponentUtils.m_130748_((Component)Component.m_237115_((String)"message.gravestone.death_id")).m_130938_(style -> style.m_131157_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/restore @s " + this.death.getId().toString() + " replace")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)this.death.getId().toString()))));
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"message.gravestone.copied", (Object[])new Object[]{deathID}));
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.m_91152_(null);
            }
        }
        return super.m_6375_(x, y, clickType);
    }

    public void drawCentered(PoseStack matrixStack, Font fontRenderer, MutableComponent text, int x, int y, int color) {
        fontRenderer.m_92877_(matrixStack, text.m_7532_(), (float)(x - fontRenderer.m_92852_((FormattedText)text) / 2), (float)y, color);
    }

    public void drawItem(PoseStack matrixStack, MutableComponent string, int height) {
        this.f_96547_.m_92877_(matrixStack, string.m_7532_(), (float)(this.guiLeft + 40), (float)height, ChatFormatting.BLACK.m_126665_().intValue());
    }

    public void drawItemSize(PoseStack matrixStack, MutableComponent string, int height) {
        this.f_96547_.m_92877_(matrixStack, string.m_7532_(), (float)(this.guiLeft + 15), (float)height, ChatFormatting.BLACK.m_126665_().intValue());
    }

    public void drawLeft(PoseStack matrixStack, MutableComponent string, int height) {
        this.f_96547_.m_92877_(matrixStack, string.m_7532_(), (float)(this.guiLeft + 7), (float)height, ChatFormatting.BLACK.m_126665_().intValue());
    }

    public void drawRight(PoseStack matrixStack, MutableComponent string, int height) {
        this.drawRight(matrixStack, string, height, 1.0f);
    }

    public void drawRight(PoseStack matrixStack, MutableComponent string, int height, float scale) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 1.0f);
        float f = 1.0f / scale;
        int strWidth = this.f_96547_.m_92852_((FormattedText)string);
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        float spacing = (9.0f * f - 9.0f) / 2.0f;
        this.f_96547_.m_92877_(matrixStack, string.m_7532_(), ((float)(this.guiLeft + 163) - (float)strWidth * scale - 14.0f) * f, (float)height * f + spacing, ChatFormatting.BLACK.m_126665_().intValue());
        matrixStack.m_85849_();
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public void m_6057_(PoseStack matrixStack, ItemStack itemStack, int mouseX, int mouseY) {
        super.m_6057_(matrixStack, itemStack, mouseX, mouseY);
    }
}

