/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pehkuiresizer.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.pehkuiresizer.PehkuiResizerMod;
import net.mcreator.pehkuiresizer.procedures.AddButtonSelfProcedure;
import net.mcreator.pehkuiresizer.procedures.ChangeAmountSelfProcedure;
import net.mcreator.pehkuiresizer.procedures.ResizeEntitiesProcedure;
import net.mcreator.pehkuiresizer.procedures.Set2pxProcedure;
import net.mcreator.pehkuiresizer.procedures.SetResetProcedure;
import net.mcreator.pehkuiresizer.procedures.SetSizeProcedure;
import net.mcreator.pehkuiresizer.procedures.SubtractButtonSelfProcedure;
import net.mcreator.pehkuiresizer.world.inventory.ResizerSelfMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResizerSelfButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ResizerSelfButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ResizerSelfButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ResizerSelfButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ResizerSelfButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ResizerSelfButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = ResizerSelfMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Set2pxProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SetResetProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ResizeEntitiesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            AddButtonSelfProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SubtractButtonSelfProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ChangeAmountSelfProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SetSizeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PehkuiResizerMod.addNetworkMessage(ResizerSelfButtonMessage.class, ResizerSelfButtonMessage::buffer, ResizerSelfButtonMessage::new, ResizerSelfButtonMessage::handler);
    }
}

