/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration.jade;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)ComponentProvider.INSTANCE, TileEntityEnderChest.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)ComponentProvider.INSTANCE, BlockEnderChest.class);
    }

    public static class ComponentProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockEntity> {
        static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("enderchests", "hud");

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            CompoundTag data = accessor.getServerData();
            if (!data.m_128441_("enderchests_basic")) {
                tooltip.add((Component)Component.m_237115_((String)"hud.enderchests.server_data_missing"));
                return;
            }
            ArrayList<Component> lines = new ArrayList<Component>();
            ChestInfoHelper.unpackHUDInfo(lines, data.m_128437_("enderchests_basic", 8));
            tooltip.addAll(lines);
        }

        public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
            if (tile instanceof TileEntityEnderChest) {
                TileEntityEnderChest tank = (TileEntityEnderChest)tile;
                data.m_128365_("enderchests_basic", (Tag)ChestInfoHelper.packHUDBasic(tank));
            }
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

