/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.renderlayers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.PlayerModelAccess;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.delegate.PlayerDelegate;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CustomCapeRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final int PART_COUNT = 16;
    private ModelPart[] customCape = NMSUtil.buildCape(64, 64, x -> 0, y -> y);
    private static VanillaCapeRenderer vanillaCape = new VanillaCapeRenderer();

    public CustomCapeRenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, float f, float g, float delta, float j, float k, float l) {
        if (abstractClientPlayer.m_20145_()) {
            return;
        }
        CapeRenderer renderer = this.getCapeRenderer(abstractClientPlayer, multiBufferSource);
        if (renderer == null) {
            return;
        }
        ItemStack itemStack = abstractClientPlayer.m_6844_(EquipmentSlot.CHEST);
        if (!itemStack.m_41619_() && itemStack.m_41720_() == Items.f_42741_) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        if (entityModel instanceof PlayerModelAccess) {
            PlayerModelAccess pma = (PlayerModelAccess)entityModel;
            if (!pma.getCloak().f_104207_) {
                return;
            }
        }
        CapeHolder holder = (CapeHolder)abstractClientPlayer;
        holder.updateSimulation(new PlayerDelegate(abstractClientPlayer), 16);
        if (ModBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, multiBufferSource, renderer, abstractClientPlayer, delta, i);
        } else {
            ModelPart[] parts = this.customCape;
            for (int part = 0; part < 16; ++part) {
                ModelPart model = parts[part];
                this.modifyPoseStack(poseStack, abstractClientPlayer, delta, part);
                renderer.render(abstractClientPlayer, part, model, poseStack, multiBufferSource, i, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }

    private void renderSmoothCape(PoseStack poseStack, MultiBufferSource multiBufferSource, CapeRenderer capeRenderer, AbstractClientPlayer abstractClientPlayer, float delta, int light) {
        VertexConsumer bufferBuilder = capeRenderer.getVertexConsumer(multiBufferSource, abstractClientPlayer);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Matrix4f oldPositionMatrix = null;
        for (int part = 0; part < 16; ++part) {
            this.modifyPoseStack(poseStack, abstractClientPlayer, delta, part);
            if (oldPositionMatrix == null) {
                oldPositionMatrix = poseStack.m_85850_().m_252922_();
            }
            if (part == 0) {
                CustomCapeRenderLayer.addTopVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, 0.3f, 0.0f, 0.0f, -0.3f, 0.0f, -0.06f, part, light);
            }
            if (part == 15) {
                CustomCapeRenderLayer.addBottomVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252922_(), 0.3f, (float)(part + 1) * 0.06f, 0.0f, -0.3f, (float)(part + 1) * 0.06f, -0.06f, part, light);
            }
            CustomCapeRenderLayer.addLeftVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, -0.3f, (float)(part + 1) * 0.06f, 0.0f, -0.3f, (float)part * 0.06f, -0.06f, part, light);
            CustomCapeRenderLayer.addRightVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, 0.3f, (float)(part + 1) * 0.06f, 0.0f, 0.3f, (float)part * 0.06f, -0.06f, part, light);
            CustomCapeRenderLayer.addBackVertex(bufferBuilder, poseStack.m_85850_().m_252922_(), oldPositionMatrix, 0.3f, (float)(part + 1) * 0.06f, -0.06f, -0.3f, (float)part * 0.06f, -0.06f, part, light);
            CustomCapeRenderLayer.addFrontVertex(bufferBuilder, oldPositionMatrix, poseStack.m_85850_().m_252922_(), 0.3f, (float)(part + 1) * 0.06f, 0.0f, -0.3f, (float)part * 0.06f, 0.0f, part, light);
            oldPositionMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            poseStack.m_85849_();
        }
    }

    private void modifyPoseStack(PoseStack poseStack, AbstractClientPlayer abstractClientPlayer, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, abstractClientPlayer, h, part);
            return;
        }
        this.modifyPoseStackVanilla(poseStack, abstractClientPlayer, h, part);
    }

    private void modifyPoseStackSimulation(PoseStack poseStack, AbstractClientPlayer abstractClientPlayer, float delta, int part) {
        BasicSimulation simulation = ((CapeHolder)abstractClientPlayer).getSimulation();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        if (abstractClientPlayer.m_6047_()) {
            height += 25.0f;
            poseStack.m_252880_(0.0f, 0.15f, 0.0f);
        }
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.m_5842_());
        poseStack.m_252781_(NMSHelper.XP.m_252977_(6.0f + height + naturalWindSwing));
        poseStack.m_252781_(NMSHelper.ZP.m_252977_(sidewaysRotationOffset / 2.0f));
        poseStack.m_252781_(NMSHelper.YP.m_252977_(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.m_252880_(-z / 16.0f, y / 16.0f, x / 16.0f);
        poseStack.m_85837_(0.0, 0.03, -0.03);
        poseStack.m_252880_(0.0f, (float)part * 1.0f / 16.0f, (float)(part * 0 / 16));
        poseStack.m_252781_(NMSHelper.XP.m_252977_(-partRotation));
        poseStack.m_252880_(0.0f, (float)(-part) * 1.0f / 16.0f, (float)(-part * 0 / 16));
        poseStack.m_85837_(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == 15) {
            return this.getRotation(delta, part - 1, simulation);
        }
        return (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private void modifyPoseStackVanilla(PoseStack poseStack, AbstractClientPlayer abstractClientPlayer, float h, int part) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.125);
        double d = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36102_, (double)abstractClientPlayer.f_36105_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19854_, (double)abstractClientPlayer.m_20185_());
        double e = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36103_, (double)abstractClientPlayer.f_36106_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19855_, (double)abstractClientPlayer.m_20186_());
        double m = Mth.m_14139_((double)h, (double)abstractClientPlayer.f_36104_, (double)abstractClientPlayer.f_36075_) - Mth.m_14139_((double)h, (double)abstractClientPlayer.f_19856_, (double)abstractClientPlayer.m_20189_());
        float n = abstractClientPlayer.f_20884_ + abstractClientPlayer.f_20883_ - abstractClientPlayer.f_20884_;
        double o = Mth.m_14031_((float)(n * ((float)Math.PI / 180)));
        double p = -Mth.m_14089_((float)(n * ((float)Math.PI / 180)));
        float height = (float)e * 10.0f;
        height = Mth.m_14036_((float)height, (float)-6.0f, (float)32.0f);
        float swing = (float)(d * o + m * p) * CustomCapeRenderLayer.easeOutSine(0.0625f * (float)part) * 100.0f;
        swing = Mth.m_14036_((float)swing, (float)0.0f, (float)(150.0f * CustomCapeRenderLayer.easeOutSine(0.0625f * (float)part)));
        float sidewaysRotationOffset = (float)(d * p - m * o) * 100.0f;
        sidewaysRotationOffset = Mth.m_14036_((float)sidewaysRotationOffset, (float)-20.0f, (float)20.0f);
        float t = Mth.m_14179_((float)h, (float)abstractClientPlayer.f_36099_, (float)abstractClientPlayer.f_36100_);
        height += Mth.m_14031_((float)(Mth.m_14179_((float)h, (float)abstractClientPlayer.f_19867_, (float)abstractClientPlayer.f_19787_) * 6.0f)) * 32.0f * t;
        if (abstractClientPlayer.m_6047_()) {
            height += 25.0f;
            poseStack.m_252880_(0.0f, 0.15f, 0.0f);
        }
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.m_5842_());
        poseStack.m_252781_(NMSHelper.XP.m_252977_(6.0f + swing / 2.0f + height + naturalWindSwing));
        poseStack.m_252781_(NMSHelper.ZP.m_252977_(sidewaysRotationOffset / 2.0f));
        poseStack.m_252781_(NMSHelper.YP.m_252977_(180.0f - sidewaysRotationOffset / 2.0f));
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / 16.0f;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static void addBackVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.m_252986_(oldMatrix, x1, y2, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV += vPerPart * (float)part).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x1, y1, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void addFrontVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.1875f;
        float maxU = 0.34375f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.m_252986_(oldMatrix, x1, y1, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y1, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y2, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV += vPerPart * (float)part).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x1, y2, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void addLeftVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.0f;
        float maxU = 0.015625f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.m_252986_(matrix, x2, y1, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV += vPerPart * (float)part).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void addRightVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.1875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.m_252986_(matrix, x2, y1, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV += vPerPart * (float)part).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void addBottomVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.328125f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.m_252986_(oldMatrix, x1, y2, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV += vPerPart * (float)part).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x1, y1, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void addTopVertex(VertexConsumer bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        bufferBuilder.m_252986_(oldMatrix, x1, y2, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(oldMatrix, x2, y2, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV += vPerPart * (float)part).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix, x1, y1, z2).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private CapeRenderer getCapeRenderer(AbstractClientPlayer abstractClientPlayer, MultiBufferSource multiBufferSource) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(abstractClientPlayer)) continue;
            return support.getRenderer();
        }
        if (NMSUtil.getPlayerCape(abstractClientPlayer) == null || abstractClientPlayer.m_20145_() || !abstractClientPlayer.m_36170_(PlayerModelPart.CAPE)) {
            return null;
        }
        CustomCapeRenderLayer.vanillaCape.vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)NMSUtil.getPlayerCape(abstractClientPlayer)));
        return vanillaCape;
    }

    private static float easeOutSine(float x) {
        return Mth.m_14031_((float)((float)((double)x * Math.PI / 2.0)));
    }
}

