/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.part.PartData;

public interface ICoreArmor
extends ICoreItem {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ENCHANTMENT_VALUE, (Object)ItemStats.ARMOR, (Object)ItemStats.MAGIC_ARMOR, (Object)ItemStats.ARMOR_TOUGHNESS, (Object[])new ItemStat[]{ItemStats.KNOCKBACK_RESISTANCE});
    public static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.REACH_DISTANCE, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.MAGIC_DAMAGE, (Object[])new ItemStat[]{ItemStats.ATTACK_SPEED, ItemStats.ATTACK_REACH, ItemStats.RANGED_DAMAGE, ItemStats.RANGED_SPEED});

    @Override
    default public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    default public boolean supportsPart(ItemStack gear, PartData part) {
        PartType type = part.getType();
        boolean supported = ICoreItem.super.supportsPart(gear, part);
        return type == PartType.MAIN && supported || type == PartType.TIP || type == PartType.LINING || supported;
    }

    @Override
    default public boolean hasTexturesFor(PartType partType) {
        return partType == PartType.MAIN || partType == PartType.TIP || partType == PartType.MISC_UPGRADE;
    }

    @Override
    default public ItemStat getDurabilityStat() {
        return ItemStats.ARMOR_DURABILITY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public ItemColor getItemColors() {
        return (stack, tintIndex) -> switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColor(stack, PartType.MAIN);
            default -> 0xFFFFFF;
        };
    }
}

