/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.block.compounder.CompounderInfo;
import net.silentchaos512.gear.block.compounder.CompounderScreen;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;

public class CompoundingRecipeCategory
implements IRecipeCategory<CompoundingRecipe> {
    private static final int GUI_START_X = 15;
    private static final int GUI_START_Y = 29;
    private static final int GUI_WIDTH = 132;
    private static final int GUI_HEIGHT = 27;
    private final CompounderInfo<?> info;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public CompoundingRecipeCategory(CompounderInfo<?> info, String categoryName, IGuiHelper guiHelper) {
        this.info = info;
        this.background = guiHelper.createDrawable(CompounderScreen.TEXTURE, 15, 29, 132, 27);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)info.getBlock()));
        this.arrow = guiHelper.drawableBuilder(CompounderScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.compounding." + categoryName);
    }

    public RecipeType<CompoundingRecipe> getRecipeType() {
        if (this.info == Const.FABRIC_COMPOUNDER_INFO) {
            return SGearJeiPlugin.COMPOUNDING_FABRIC_TYPE;
        }
        if (this.info == Const.GEM_COMPOUNDER_INFO) {
            return SGearJeiPlugin.COMPOUNDING_GEM_TYPE;
        }
        if (this.info == Const.METAL_COMPOUNDER_INFO) {
            return SGearJeiPlugin.COMPOUNDING_METAL_TYPE;
        }
        throw new IllegalStateException("Unknown JEI recipe type: " + this.info.getRecipeType());
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompoundingRecipe recipe, IFocusGroup focuses) {
        for (int i = 0; i < this.info.getInputSlotCount() && i < recipe.m_7527_().size(); ++i) {
            List<ItemStack> items = Arrays.asList(((Ingredient)recipe.m_7527_().get(i)).m_43908_());
            builder.addSlot(RecipeIngredientRole.INPUT, 18 * i + 17 - 15, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, CompoundingRecipeCategory.shiftIngredients(items, 3 * i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 111, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(recipe.m_8043_(null)));
    }

    private static List<ItemStack> shiftIngredients(List<ItemStack> list, int amount) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(list);
        if (ret.isEmpty()) {
            return ret;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = (ItemStack)ret.get(ret.size() - 1);
            ret.remove(ret.size() - 1);
            ret.add(0, stack);
        }
        return ret;
    }

    public void draw(CompoundingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 78, 5);
    }
}

