/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.gear.util.TextUtil;

public class GearCraftingRecipeCategoryJei
implements IRecipeCategory<CraftingRecipe> {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 132;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public GearCraftingRecipeCategoryJei(IGuiHelper guiHelper) {
        ModResourceLocation location = SilentGear.getId("textures/gui/gear_crafting_jei.png");
        this.background = guiHelper.createDrawable((ResourceLocation)location, 0, 0, 160, 132);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(SgItems.BLUEPRINT_PACKAGE));
        this.localizedName = TextUtil.translate("gui", "category.gearCrafting");
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return SGearJeiPlugin.GEAR_CRAFTING_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(recipe.m_8043_(null)));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
                if (index >= recipe.m_7527_().size()) continue;
                slotBuilder.addIngredients((Ingredient)recipe.m_7527_().get(index));
            }
        }
    }

    public void draw(CraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        NonNullList ingredients = recipe.m_7527_();
        for (int i = 0; i < ingredients.size(); ++i) {
            Component text;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (!(ingredient instanceof IGearIngredient) || (text = (Component)((IGearIngredient)ingredient).getJeiHint().orElse(null)) == null) continue;
            String prefix = i + 1 + ": ";
            lines.add(Component.m_237113_((String)prefix).m_7220_(text));
        }
        stack.m_85836_();
        float scale = lines.size() > 5 ? 0.75f : 1.0f;
        stack.m_85841_(scale, scale, 1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        int y = (int)(56.0f / scale);
        for (Component component : lines) {
            font.m_92744_(stack, component.m_7532_(), 0.0f, (float)y, -1);
            y += 10;
        }
        stack.m_85849_();
    }
}

