/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.compounder.MetalAlloyerScreen;
import net.silentchaos512.gear.block.compounder.RecrystallizerScreen;
import net.silentchaos512.gear.block.compounder.RefabricatorScreen;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.compat.jei.CompoundingRecipeCategory;
import net.silentchaos512.gear.compat.jei.GearCraftingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.MaterialGraderRecipeCategory;
import net.silentchaos512.gear.compat.jei.SalvagingRecipeCategoryJei;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.SgBlocks;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

@JeiPlugin
public class SGearJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGear.getId("plugin/main");
    public static final RecipeType<CompoundingRecipe> COMPOUNDING_FABRIC_TYPE = RecipeType.create((String)"silentgear", (String)"compounding_fabric", CompoundingRecipe.class);
    public static final RecipeType<CompoundingRecipe> COMPOUNDING_GEM_TYPE = RecipeType.create((String)"silentgear", (String)"compounding_gem", CompoundingRecipe.class);
    public static final RecipeType<CompoundingRecipe> COMPOUNDING_METAL_TYPE = RecipeType.create((String)"silentgear", (String)"compounding_metal", CompoundingRecipe.class);
    static final RecipeType<CraftingRecipe> GEAR_CRAFTING_TYPE = RecipeType.create((String)"silentgear", (String)"gear_crafting", CraftingRecipe.class);
    static final RecipeType<MaterialGraderRecipeCategory.GraderRecipe> GRADING_TYPE = RecipeType.create((String)"silentgear", (String)"grading", MaterialGraderRecipeCategory.GraderRecipe.class);
    static final RecipeType<SalvagingRecipe> SALVAGING_TYPE = RecipeType.create((String)"silentgear", (String)"salvaging", SalvagingRecipe.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new GearCraftingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory(Const.FABRIC_COMPOUNDER_INFO, "fabric", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory(Const.GEM_COMPOUNDER_INFO, "gem", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new CompoundingRecipeCategory(Const.METAL_COMPOUNDER_INFO, "metal", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new MaterialGraderRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingRecipeCategoryJei(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        for (RepairKitItem repairKitItem : SgItems.getItems(RepairKitItem.class)) {
            String itemName = NameUtils.fromItem((ItemLike)repairKitItem).m_135815_();
            reg.addRecipes(RecipeTypes.CRAFTING, Collections.singletonList(new ShapelessRecipe((ResourceLocation)SilentGear.getId(itemName + "_fill_hint"), "", CraftingBookCategory.MISC, new ItemStack((ItemLike)repairKitItem), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairKitItem}), PartMaterialIngredient.of(PartType.MAIN), PartMaterialIngredient.of(PartType.MAIN), PartMaterialIngredient.of(PartType.MAIN)}))));
            reg.addRecipes(RecipeTypes.CRAFTING, Collections.singletonList(new ShapelessRecipe((ResourceLocation)SilentGear.getId(itemName + "_fill_hint_frag"), "", CraftingBookCategory.MISC, new ItemStack((ItemLike)repairKitItem), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairKitItem}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{SgItems.FRAGMENT}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{SgItems.FRAGMENT}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{SgItems.FRAGMENT})}))));
        }
        reg.addRecipes(GEAR_CRAFTING_TYPE, SGearJeiPlugin.getRecipes(recipeManager, SGearJeiPlugin::isGearCraftingRecipe, CraftingRecipe.class));
        reg.addRecipes(COMPOUNDING_FABRIC_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.COMPOUNDING_FABRIC_TYPE.get(), CompoundingRecipe.class));
        reg.addRecipes(COMPOUNDING_GEM_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.COMPOUNDING_GEM_TYPE.get(), CompoundingRecipe.class));
        reg.addRecipes(COMPOUNDING_METAL_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.COMPOUNDING_METAL_TYPE.get(), CompoundingRecipe.class));
        for (int i = 2; i <= 4; ++i) {
            reg.addRecipes(COMPOUNDING_FABRIC_TYPE, Collections.singletonList(CompoundingRecipe.makeExample(Const.FABRIC_COMPOUNDER_INFO, i, new FabricCompoundingRecipe(SilentGear.getId("fabric_example_" + i)))));
            reg.addRecipes(COMPOUNDING_GEM_TYPE, Collections.singletonList(CompoundingRecipe.makeExample(Const.GEM_COMPOUNDER_INFO, i, new GemCompoundingRecipe(SilentGear.getId("gem_example_" + i)))));
            reg.addRecipes(COMPOUNDING_METAL_TYPE, Collections.singletonList(CompoundingRecipe.makeExample(Const.METAL_COMPOUNDER_INFO, i, new MetalCompoundingRecipe(SilentGear.getId("metal_example_" + i)))));
        }
        reg.addRecipes(GRADING_TYPE, Collections.singletonList(new MaterialGraderRecipeCategory.GraderRecipe()));
        reg.addRecipes(SALVAGING_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.SALVAGING_TYPE.get(), SalvagingRecipe.class));
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.RED_CARD_UPGRADE);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.SPOON_UPGRADE);
        for (Item item2 : SgItems.getItems(item -> item instanceof ICoreTool)) {
            SGearJeiPlugin.addInfoPage(reg, (ItemLike)item2);
        }
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeManager recipeManager, net.minecraft.world.item.crafting.RecipeType recipeType, Class<R> recipeClass) {
        return SGearJeiPlugin.getRecipes(recipeManager, (Recipe<?> r) -> r.m_6671_() == recipeType, recipeClass);
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeManager recipeManager, RecipeSerializer<?> recipeSerializer, Class<R> recipeClass) {
        return SGearJeiPlugin.getRecipes(recipeManager, (Recipe<?> r) -> r.m_7707_() == recipeSerializer, recipeClass);
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeManager recipeManager, Predicate<Recipe<?>> predicate, Class<R> recipeClass) {
        return recipeManager.m_44051_().stream().filter(predicate).map(recipeClass::cast).collect(Collectors.toList());
    }

    private static boolean isGearCraftingRecipe(Recipe<?> recipe) {
        RecipeSerializer serializer = recipe.m_7707_();
        return serializer == SgRecipes.SHAPED_GEAR.get() || serializer == SgRecipes.SHAPELESS_GEAR.get() || serializer == SgRecipes.COMPOUND_PART.get();
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50091_), new RecipeType[]{GEAR_CRAFTING_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.REFABRICATOR), new RecipeType[]{COMPOUNDING_FABRIC_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.RECRYSTALLIZER), new RecipeType[]{COMPOUNDING_GEM_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.METAL_ALLOYER), new RecipeType[]{COMPOUNDING_METAL_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.MATERIAL_GRADER), new RecipeType[]{GRADING_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.SALVAGER), new RecipeType[]{SALVAGING_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(RefabricatorScreen.class, 90, 30, 28, 23, new RecipeType[]{COMPOUNDING_FABRIC_TYPE});
        reg.addRecipeClickArea(RecrystallizerScreen.class, 90, 30, 28, 23, new RecipeType[]{COMPOUNDING_GEM_TYPE});
        reg.addRecipeClickArea(MetalAlloyerScreen.class, 90, 30, 28, 23, new RecipeType[]{COMPOUNDING_METAL_TYPE});
        reg.addRecipeClickArea(GraderScreen.class, 48, 30, 28, 23, new RecipeType[]{GRADING_TYPE});
        reg.addRecipeClickArea(SalvagerScreen.class, 30, 30, 28, 23, new RecipeType[]{SALVAGING_TYPE});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)SgItems.FRAGMENT.get(), (stack, context) -> {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            return material != null ? material.getId().toString() : "";
        });
        IIngredientSubtypeInterpreter customMaterials = (stack, context) -> {
            MaterialInstance material = CustomMaterialItem.getMaterial(stack);
            return material != null ? material.getId().toString() : "";
        };
        reg.registerSubtypeInterpreter((Item)SgItems.CUSTOM_GEM.get(), customMaterials);
        reg.registerSubtypeInterpreter((Item)SgItems.CUSTOM_INGOT.get(), customMaterials);
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item) {
        String key = SGearJeiPlugin.getDescKey(NameUtils.fromItem((ItemLike)item));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, String name, Collection<ItemLike> items) {
        String key = SGearJeiPlugin.getDescKey(SilentGear.getId(name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item, Stream<ItemStack> variants) {
        String key = SGearJeiPlugin.getDescKey(NameUtils.fromItem((ItemLike)item));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)key)});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.m_135827_() + "." + name.m_135815_() + ".desc";
    }
}

