/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.compounder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.compounder.CompounderInfo;
import net.silentchaos512.gear.block.compounder.CompounderTileEntity;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.item.CustomMaterialItem;

public class CompoundingRecipe
implements Recipe<CompounderTileEntity<?>> {
    private final ResourceLocation recipeId;
    final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    ItemStack result = ItemStack.f_41583_;

    public CompoundingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public static CompoundingRecipe makeExample(CompounderInfo<?> info, int count, CompoundingRecipe recipe) {
        IMaterialCategory[] cats = info.getCategories().toArray(new IMaterialCategory[0]);
        for (int i = 0; i < count; ++i) {
            recipe.ingredients.add(PartMaterialIngredient.of(PartType.MAIN, GearType.ALL, cats));
        }
        recipe.result = new ItemStack((ItemLike)info.getOutputItem(), count);
        return recipe;
    }

    public boolean matches(CompounderTileEntity<?> inv, Level worldIn) {
        HashSet<Integer> matches = new HashSet<Integer>();
        int inputs = 0;
        for (int i = 0; i < inv.getInputSlotCount(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            ++inputs;
        }
        for (Ingredient ingredient : this.ingredients) {
            boolean found = false;
            for (int i = 0; i < inv.getInputSlotCount(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack.m_41619_() || !ingredient.test(stack)) continue;
                found = true;
                matches.add(i);
            }
            if (found) continue;
            return false;
        }
        int matchCount = matches.size();
        return matchCount == inputs && matchCount == this.ingredients.size();
    }

    public ItemStack assemble(CompounderTileEntity<?> inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= this.ingredients.size();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ret = NonNullList.m_122779_();
        ret.addAll(this.ingredients);
        return ret;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.COMPOUNDING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)SgRecipes.COMPOUNDING_TYPE.get();
    }

    public static class Serializer<T extends CompoundingRecipe>
    implements RecipeSerializer<T> {
        private final Function<ResourceLocation, T> factory;

        public Serializer(Function<ResourceLocation, T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            CompoundingRecipe ret = (CompoundingRecipe)this.factory.apply(recipeId);
            JsonArray array = json.getAsJsonArray("ingredients");
            for (JsonElement je : array) {
                ret.ingredients.add(Ingredient.m_43917_((JsonElement)je));
            }
            JsonObject resultJson = json.getAsJsonObject("result");
            ResourceLocation itemId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)resultJson, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                throw new JsonParseException("Unknown item: " + itemId);
            }
            int count = GsonHelper.m_13824_((JsonObject)resultJson, (String)"count", (int)1);
            if (item instanceof CustomMaterialItem && resultJson.has("material")) {
                ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)resultJson, (String)"material"));
                ret.result = ((CustomMaterialItem)item).create(LazyMaterialInstance.of(id), count);
            }
            if (ret.result.m_41619_()) {
                ret.result = new ItemStack((ItemLike)item, count);
            }
            return (T)ret;
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CompoundingRecipe ret = (CompoundingRecipe)this.factory.apply(recipeId);
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                ret.ingredients.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ret.result = buffer.m_130267_();
            return (T)ret;
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.writeByte(((CompoundingRecipe)recipe).ingredients.size());
            ((CompoundingRecipe)recipe).ingredients.forEach(ingredient -> ingredient.m_43923_(buffer));
            buffer.m_130055_(((CompoundingRecipe)recipe).result);
        }
    }
}

