/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.lib.util.NameUtils;

public final class SalvagingRecipeBuilder {
    private final Ingredient ingredient;
    private final RecipeSerializer<?> serializer;
    private final Collection<ItemStack> results = new ArrayList<ItemStack>();

    private SalvagingRecipeBuilder(Ingredient ingredient, RecipeSerializer<?> serializer) {
        this.ingredient = ingredient;
        this.serializer = serializer;
    }

    public static SalvagingRecipeBuilder builder(ItemLike ingredient) {
        return SalvagingRecipeBuilder.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}));
    }

    public static SalvagingRecipeBuilder builder(TagKey<Item> ingredient) {
        return SalvagingRecipeBuilder.builder(Ingredient.m_204132_(ingredient));
    }

    public static SalvagingRecipeBuilder builder(Ingredient ingredient) {
        return new SalvagingRecipeBuilder(ingredient, (RecipeSerializer)SgRecipes.SALVAGING.get());
    }

    public static SalvagingRecipeBuilder gearBuilder(ICoreItem item) {
        return new SalvagingRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (RecipeSerializer)SgRecipes.SALVAGING_GEAR.get());
    }

    public SalvagingRecipeBuilder addResult(ItemLike item) {
        return this.addResult(item, 1);
    }

    public SalvagingRecipeBuilder addResult(ItemLike item, int count) {
        this.results.add(new ItemStack(item, count));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.serializer == SgRecipes.SALVAGING.get() && this.results.isEmpty()) {
            throw new IllegalStateException("Empty results for standard salvaging recipe");
        }
        consumer.accept(new Result(id, this));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final SalvagingRecipeBuilder builder;

        public Result(ResourceLocation id, SalvagingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.builder.ingredient.m_43942_());
            if (!this.builder.results.isEmpty()) {
                JsonArray results = new JsonArray();
                this.builder.results.forEach(stack -> results.add((JsonElement)this.serializeItem((ItemStack)stack)));
                json.add("results", (JsonElement)results);
            }
        }

        private JsonObject serializeItem(ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("item", NameUtils.fromItem((ItemStack)stack).toString());
            if (stack.m_41613_() > 1) {
                json.addProperty("count", (Number)stack.m_41613_());
            }
            return json;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

