/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.init.SgItems;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainer;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class BlueprintBookItem
extends Item
implements IBlueprint,
IContainerItem,
ICycleItem {
    private static final String NBT_SELECTED = "Selected";
    public static final int INVENTORY_SIZE = 54;

    public BlueprintBookItem(Item.Properties properties) {
        super(properties);
    }

    private static int clampSelectedSlot(int slot) {
        return Mth.m_14045_((int)slot, (int)0, (int)53);
    }

    public static int getSelectedSlot(ItemStack book) {
        return BlueprintBookItem.clampSelectedSlot(book.m_41784_().m_128451_(NBT_SELECTED));
    }

    public static void setSelectedSlot(ItemStack book, int slot) {
        book.m_41784_().m_128405_(NBT_SELECTED, BlueprintBookItem.clampSelectedSlot(slot));
    }

    private ItemStack getSelectedItem(ItemStack book) {
        return this.getInventory(book).getStackInSlot(BlueprintBookItem.getSelectedSlot(book));
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.m_41619_() && this.canStore(selected)) {
            return ((AbstractBlueprintItem)selected.m_41720_()).getPartType(selected);
        }
        return PartType.MISC_UPGRADE;
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.m_41619_() && this.canStore(selected)) {
            return ((AbstractBlueprintItem)selected.m_41720_()).getGearType(selected);
        }
        return GearType.NONE;
    }

    @Override
    public int getInventorySize(ItemStack stack) {
        return 54;
    }

    @Override
    public boolean canStore(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof AbstractBlueprintItem && !((AbstractBlueprintItem)item).isSingleUse();
    }

    public static void openContainer(ServerPlayer playerIn, ItemStack stack) {
        NetworkHooks.openScreen((ServerPlayer)playerIn, (MenuProvider)new SimpleMenuProvider((id, inv, z) -> new BlueprintBookContainer(id, inv, stack), (Component)Component.m_237115_((String)"container.silentgear.blueprint_book")), buf -> buf.m_130055_(stack));
    }

    @Override
    public void onCycleKeyPress(ItemStack stack, KeyPressOnItemPacket.Type direction) {
        int current = BlueprintBookItem.getSelectedSlot(stack);
        IItemHandler inventory = this.getInventory(stack);
        for (int i = 1; i <= inventory.getSlots(); ++i) {
            ItemStack inSlot;
            int index = current + i * direction.direction;
            if (index < 0) {
                index += inventory.getSlots();
            }
            if (index >= inventory.getSlots()) {
                index -= inventory.getSlots();
            }
            if ((inSlot = inventory.getStackInSlot(index)).m_41619_()) continue;
            BlueprintBookItem.setSelectedSlot(stack, index);
            return;
        }
        if (this.getSelectedItem(stack).m_41619_()) {
            BlueprintBookItem.setSelectedSlot(stack, 0);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            BlueprintBookItem.openContainer((ServerPlayer)playerIn, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public ItemStack createdFullyLoadedBook() {
        ItemStack filled = new ItemStack((ItemLike)this);
        IItemHandler inventory = this.getInventory(filled);
        ArrayList<Item> blueprints = new ArrayList<Item>(SgItems.getItems(item -> this.canStore(new ItemStack((ItemLike)item))));
        for (int i = 0; i < blueprints.size() && i < this.getInventorySize(filled); ++i) {
            inventory.insertItem(i, new ItemStack((ItemLike)blueprints.get(i)), false);
        }
        this.saveInventory(filled, inventory);
        filled.m_41714_((Component)TextUtil.translate("item", "blueprint_book.fully_loaded"));
        return filled;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.m_41619_()) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.translate("item", "blueprint_book.selected"), Color.SKYBLUE).m_7220_((Component)selected.m_41786_().m_6881_().m_130940_(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)TextUtil.translate("item", "blueprint_book.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE)));
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.m_41777_();
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }
}

