/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

@Deprecated
public class GearDiggerItem
extends DiggerItem
implements ICoreTool {
    private static final Map<ToolAction, TagKey<Block>> TOOL_TYPES = ImmutableMap.builder().put((Object)ToolActions.AXE_DIG, (Object)BlockTags.f_144280_).put((Object)ToolActions.HOE_DIG, (Object)BlockTags.f_144281_).put((Object)ToolActions.PICKAXE_DIG, (Object)BlockTags.f_144282_).put((Object)ToolActions.SHOVEL_DIG, (Object)BlockTags.f_144283_).build();
    private final TagKey<Block> blocks;
    private final GearType gearType;
    private final Set<Material> extraMaterials;

    public GearDiggerItem(GearType gearType, TagKey<Block> blocks, Set<Material> extraMaterials, Item.Properties properties) {
        super(0.0f, 1.0f, (Tier)GearHelper.DEFAULT_DUMMY_TIER, blocks, properties);
        this.gearType = gearType;
        this.blocks = blocks;
        this.extraMaterials = Collections.unmodifiableSet(extraMaterials);
    }

    public Tier m_43314_() {
        return Config.Common.isLoaded() ? (Tier)Config.Common.dummyToolTier.get() : GearHelper.DEFAULT_DUMMY_TIER;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (GearHelper.isBroken(stack)) {
            return false;
        }
        return this.gearType.canPerformAction(toolAction);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        for (Map.Entry<ToolAction, TagKey<Block>> entry : TOOL_TYPES.entrySet()) {
            ToolAction action = entry.getKey();
            TagKey<Block> tag = entry.getValue();
            if (!this.canPerformAction(stack, action) || !GearHelper.isCorrectToolForDrops(stack, state, tag, this.extraMaterials)) continue;
            return true;
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return GearHelper.getDestroySpeed(stack, state, this.extraMaterials);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return GearHelper.onItemUse(context);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hitEntity(stack, target, attacker);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entity) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entity);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, this.gearType.getDurabilityStat());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public Rarity m_41460_(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

