/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleEasings;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleModifiers;
import virtuoel.pehkui.api.ScaleOperations;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;

public class ScaleRegistries {
    private static final Map<Map<ResourceLocation, ?>, ResourceLocation> REGISTRY_IDS = new IdentityHashMap();
    private static final Map<ResourceLocation, Supplier<?>> DEFAULT_ENTRIES = new LinkedHashMap();
    private static final Map<ResourceLocation, ResourceLocation> DEFAULT_IDS = new LinkedHashMap<ResourceLocation, ResourceLocation>();
    public static final BiMap<ResourceLocation, ScaleType> SCALE_TYPES = ScaleRegistries.create("scale_types", "invalid", () -> ScaleTypes.INVALID);
    public static final BiMap<ResourceLocation, ScaleModifier> SCALE_MODIFIERS = ScaleRegistries.create("scale_modifiers", "identity", () -> ScaleModifiers.IDENTITY);
    public static final BiMap<ResourceLocation, Float2FloatFunction> SCALE_EASINGS = ScaleRegistries.create("scale_easings", "linear", () -> ScaleEasings.LINEAR);
    public static final BiMap<ResourceLocation, DoubleBinaryOperator> SCALE_OPERATIONS = ScaleRegistries.create("scale_operations", "noop", () -> ScaleOperations.NOOP);

    public static <E> E register(Map<ResourceLocation, E> registry, ResourceLocation id, E entry) {
        return (E)registry.computeIfAbsent(id, i -> entry);
    }

    public static <E> E getEntry(Map<ResourceLocation, E> registry, ResourceLocation id) {
        return registry.get(id);
    }

    public static <E> ResourceLocation getDefaultId(BiMap<ResourceLocation, E> registry) {
        return DEFAULT_IDS.get(REGISTRY_IDS.get(registry));
    }

    public static <E> ResourceLocation getId(BiMap<ResourceLocation, E> registry, E entry) {
        return (ResourceLocation)registry.inverse().get(entry);
    }

    private static <E> BiMap<ResourceLocation, E> create(String id, String defaultPath, Supplier<E> defaultEntry) {
        return ScaleRegistries.create(Pehkui.id(id), Pehkui.id(defaultPath), defaultEntry);
    }

    private static <E> BiMap<ResourceLocation, E> create(ResourceLocation id, ResourceLocation defaultId, Supplier<E> defaultEntry) {
        BiMap registry = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        REGISTRY_IDS.put((Map<ResourceLocation, ?>)registry, id);
        DEFAULT_IDS.put(id, defaultId);
        DEFAULT_ENTRIES.put(id, defaultEntry);
        return registry;
    }

    private ScaleRegistries() {
    }
}

