/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.util.I18nUtils;

public class DebugPacket {
    private final Type type;

    public DebugPacket(Type type) {
        this.type = type;
    }

    protected DebugPacket(FriendlyByteBuf buf) {
        Type read;
        try {
            read = (Type)buf.m_130066_(Type.class);
        }
        catch (Exception e) {
            read = null;
        }
        this.type = read;
    }

    public static void handle(DebugPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Type type = msg.type;
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft client = Minecraft.m_91087_();
            switch (type) {
                case MIXIN_AUDIT: {
                    client.f_91074_.m_5661_(I18nUtils.translate("commands.pehkui.debug.audit.start.client", "Starting Mixin environment audit (client)..."), false);
                    MixinEnvironment.getCurrentEnvironment().audit();
                    client.f_91074_.m_5661_(I18nUtils.translate("commands.pehkui.debug.audit.end.client", "Mixin environment audit (client) complete!"), false);
                    break;
                }
                case GARBAGE_COLLECT: {
                    System.gc();
                    break;
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
    }

    public static enum Type {
        MIXIN_AUDIT,
        GARBAGE_COLLECT;

    }
}

