/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.blocks.CakeEffectsHolder;
import einstein.jmc.client.gui.screens.inventory.CakeOvenScreen;
import einstein.jmc.data.CakeEffects;
import einstein.jmc.data.CakeEffectsManager;
import einstein.jmc.data.providers.ModAdvancementProvider;
import einstein.jmc.data.providers.ModBlockStateProvider;
import einstein.jmc.data.providers.ModBlockTagsProvider;
import einstein.jmc.data.providers.ModCakeEffectsProvider;
import einstein.jmc.data.providers.ModItemModelProvider;
import einstein.jmc.data.providers.ModItemTagsProvider;
import einstein.jmc.data.providers.ModLootTableProvider;
import einstein.jmc.data.providers.ModPOITagsProvider;
import einstein.jmc.data.providers.ModRecipeProvider;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModClientConfigs;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.init.ModItems;
import einstein.jmc.init.ModMenuTypes;
import einstein.jmc.init.ModPotions;
import einstein.jmc.init.ModVillagers;
import einstein.jmc.platform.ForgeRegistryHelper;
import einstein.jmc.platform.Services;
import einstein.jmc.platform.services.RegistryHelper;
import einstein.jmc.util.EmeraldsForItems;
import einstein.jmc.util.ItemsForEmeralds;
import einstein.jmc.util.Util;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.jetbrains.annotations.Nullable;

@Mod(value="jmc")
public class JustMoreCakesForge {
    private static CakeEffectsManager CAKE_EFFECTS_MANAGER;

    public JustMoreCakesForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        JustMoreCakes.init();
        modEventBus.register((Object)this);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onParallelDispatch);
        modEventBus.addListener(this::generateData);
        modEventBus.addListener(this::registerCreativeTab);
        ForgeRegistryHelper.ITEMS.register(modEventBus);
        ForgeRegistryHelper.BLOCKS.register(modEventBus);
        ForgeRegistryHelper.BLOCK_ENTITIES.register(modEventBus);
        ForgeRegistryHelper.MENU_TYPES.register(modEventBus);
        ForgeRegistryHelper.RECIPE_SERIALIZERS.register(modEventBus);
        ForgeRegistryHelper.RECIPE_TYPES.register(modEventBus);
        ForgeRegistryHelper.POI_TYPES.register(modEventBus);
        ForgeRegistryHelper.VILLAGER_PROFESSIONS.register(modEventBus);
        ForgeRegistryHelper.MOB_EFFECTS.register(modEventBus);
        ForgeRegistryHelper.POTIONS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::missingMappings);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJump);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTick);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        MinecraftForge.EVENT_BUS.addListener(this::onVillagerTradesEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onWanderingTradesEvent);
        if (Services.PLATFORM.isModLoaded("cakechomps")) {
            MinecraftForge.EVENT_BUS.addListener(this::onBlockRightClicked);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModClientConfigs.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModCommonConfigs.SPEC);
    }

    void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output));
        ModBlockTagsProvider blockTags = new ModBlockTagsProvider(output, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, lookupProvider, blockTags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPOITagsProvider(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ModCakeEffectsProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, helper));
    }

    void registerCreativeTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(JustMoreCakes.loc("jmc_tab"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)ModBlocks.CHOCOLATE_CAKE.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.jmc.jmc_tab")).m_257501_((displayParameters, output) -> RegistryHelper.CREATIVE_TAB_ITEMS.forEach(cake -> output.m_246326_((ItemLike)cake.get()))).m_257652_());
    }

    void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        BlockHitResult result = event.getHitVec();
        Util.useCake(player, pos, hand, () -> {
            InteractionResult interact;
            UseOnContext useoncontext = new UseOnContext(player, hand, result);
            ItemStack stack = player.m_21120_(hand);
            if (event.getUseItem() != Event.Result.DENY && (interact = stack.onItemUseFirst(useoncontext)) != InteractionResult.PASS) {
                return false;
            }
            boolean flag = !player.m_21205_().m_41619_() || !player.m_21206_().m_41619_();
            boolean flag1 = player.m_36341_() && flag && (!player.m_21205_().doesSneakBypassUse((LevelReader)player.m_9236_(), pos, player) || !player.m_21206_().doesSneakBypassUse((LevelReader)player.m_9236_(), pos, player));
            return event.getUseBlock() == Event.Result.ALLOW || event.getUseBlock() != Event.Result.DENY && !flag1;
        });
    }

    void onAddReloadListeners(AddReloadListenerEvent event) {
        CAKE_EFFECTS_MANAGER = new CakeEffectsManager();
        event.addListener((PreparableReloadListener)CAKE_EFFECTS_MANAGER);
    }

    public static void addCakeEffects() {
        if (CAKE_EFFECTS_MANAGER == null) {
            throw new IllegalStateException("Can't retrieve CakeEffectsManager until resources have loaded");
        }
        CAKE_EFFECTS_MANAGER.getRegisteredCakeEffects().forEach((location, cakeEffects) -> {
            Block patt8626$temp = cakeEffects.cake();
            if (patt8626$temp instanceof CakeEffectsHolder) {
                CakeEffectsHolder holder = (CakeEffectsHolder)patt8626$temp;
                holder.addCakeEffects((CakeEffects)cakeEffects);
            } else {
                JustMoreCakes.LOGGER.error("Failed to load cake effect for block {} as it is not valid cake effect holder", (Object)cakeEffects.cake());
            }
        });
    }

    void onServerStarting(ServerStartingEvent event) {
        JustMoreCakes.onServerStarting(event.getServer());
    }

    void onServerStarted(ServerStartedEvent event) {
        JustMoreCakesForge.addCakeEffects();
    }

    void commonSetup(FMLCommonSetupEvent event) {
        GiveGiftToHero.f_147550_.put(ModVillagers.CAKE_BAKER.get(), JustMoreCakes.loc("gameplay/hero_of_the_village/cake_baker_gift"));
        JustMoreCakes.commonSetup();
    }

    void onParallelDispatch(ParallelDispatchEvent event) {
        event.enqueueWork(ModPotions::registerPotionRecipes);
    }

    void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ModMenuTypes.CAKE_OVEN.get(), CakeOvenScreen::new);
    }

    void missingMappings(MissingMappingsEvent event) {
        this.handleMissingMappings(event, ForgeRegistries.ITEMS, this::missingItems);
        this.handleMissingMappings(event, ForgeRegistries.BLOCKS, this::missingBlock);
    }

    @Nullable
    private Item missingItems(String name) {
        if (name.equals("cheese")) {
            return ModItems.CREAM_CHEESE.get();
        }
        return this.missingBlock(name).m_5456_();
    }

    @Nullable
    private Block missingBlock(String name) {
        String[] removedCakes = new String[]{"sprinkle_cake", "christmas_cake"};
        for (String cake : removedCakes) {
            if (name.equals(cake)) {
                return Blocks.f_50145_;
            }
            if (name.equals("candle_" + cake)) {
                return Blocks.f_152525_;
            }
            for (DyeColor color : DyeColor.values()) {
                if (!name.equals(color + "_candle_" + cake)) continue;
                return Util.getBlock(JustMoreCakes.mcLoc(color + "_candle_cake"));
            }
        }
        return switch (name) {
            case "cheese_cake" -> ModBlocks.CHEESECAKE.get();
            case "triple_decker_cake" -> ModBlocks.THREE_TIERED_CAKE.get();
            case "birthday_cake" -> Blocks.f_50145_;
            default -> null;
        };
    }

    private <T> void handleMissingMappings(MissingMappingsEvent event, IForgeRegistry<T> registry, Function<String, T> function) {
        List mappings = event.getMappings(registry.getRegistryKey(), "jmc");
        for (MissingMappingsEvent.Mapping mapping : mappings) {
            T value = function.apply(mapping.getKey().m_135815_());
            if (value != null) {
                mapping.remap(value);
                continue;
            }
            JustMoreCakes.LOGGER.info("Failed to remap (" + mapping.getKey().toString() + ") of registry (" + registry.getRegistryName() + ")");
            mapping.fail();
        }
    }

    void onEntityJump(LivingEvent.LivingJumpEvent event) {
        Util.livingEntityJump((Entity)event.getEntity());
    }

    void onEntityTick(LivingEvent.LivingTickEvent event) {
        Util.livingEntityTick(event.getEntity().m_9236_(), event.getEntity());
    }

    void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == ModVillagers.CAKE_BAKER.get()) {
            List novice = (List)event.getTrades().get(1);
            List apprentice = (List)event.getTrades().get(2);
            List journeyman = (List)event.getTrades().get(3);
            List expert = (List)event.getTrades().get(4);
            List master = (List)event.getTrades().get(5);
            novice.add(new EmeraldsForItems((ItemLike)Items.f_42405_, 20, 1, 16, 2));
            novice.add(new EmeraldsForItems((ItemLike)Items.f_42521_, 5, 1, 16, 2));
            novice.add(new ItemsForEmeralds((ItemLike)Items.f_42501_, 2, 4, 1));
            novice.add(new ItemsForEmeralds((ItemLike)Items.f_42455_, 2, 1, 2));
            apprentice.add(new ItemsForEmeralds((ItemLike)Blocks.f_50145_.m_5456_(), 1, 1, 10));
            apprentice.add(new ItemsForEmeralds((ItemLike)Items.f_42533_, 3, 1, 5));
            apprentice.add(new ItemsForEmeralds((ItemLike)ModBlocks.CARROT_CAKE.get().m_5456_(), 1, 1, 10));
            journeyman.add(new EmeraldsForItems((ItemLike)Items.f_42413_, 15, 1, 16, 10));
            journeyman.add(new EmeraldsForItems((ItemLike)Items.f_42619_, 22, 1, 16, 20));
            journeyman.add(new EmeraldsForItems((ItemLike)Items.f_41909_, 2, 1, 10));
            expert.add(new EmeraldsForItems((ItemLike)ModItems.CREAM_CHEESE.get(), 1, 6, 30));
            expert.add(new ItemsForEmeralds((ItemLike)ModItems.CUPCAKE.get(), 4, 1, 16, 15));
            master.add(new ItemsForEmeralds((ItemLike)ModBlocks.THREE_TIERED_CAKE.get().m_5456_(), 15, 1, 30));
            master.add(new ItemsForEmeralds((ItemLike)ModBlocks.CREEPER_CAKE.get().m_5456_(), 20, 1, 30));
        }
    }

    void onWanderingTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add(new ItemsForEmeralds((ItemLike)ModBlocks.SEED_CAKE.get().m_5456_(), 2, 1, 12));
    }
}

