/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.menu.cakeoven;

import einstein.jmc.init.ModMenuTypes;
import einstein.jmc.menu.cakeoven.CakeOvenFuelSlot;
import einstein.jmc.menu.cakeoven.CakeOvenResultSlot;
import einstein.jmc.platform.Services;
import einstein.jmc.util.CakeOvenConstants;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CakeOvenMenu
extends AbstractContainerMenu
implements CakeOvenConstants {
    private final Container container;
    private final ContainerData data;

    public CakeOvenMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(4));
    }

    public CakeOvenMenu(int id, Inventory inventory, Container container, ContainerData data) {
        super(ModMenuTypes.CAKE_OVEN.get(), id);
        CakeOvenMenu.m_38869_((Container)container, (int)6);
        CakeOvenMenu.m_38886_((ContainerData)data, (int)4);
        this.container = container;
        this.data = data;
        this.m_38897_(new Slot(container, 0, 52, 26));
        this.m_38897_(new Slot(container, 1, 70, 26));
        this.m_38897_(new Slot(container, 2, 52, 44));
        this.m_38897_(new Slot(container, 3, 70, 44));
        this.m_38897_(new CakeOvenFuelSlot(this, container, 4, 19, 44));
        this.m_38897_(new CakeOvenResultSlot(inventory.f_35978_, container, 5, 130, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(data);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            int containerSize = 6;
            int inventoryEnd = containerSize + 27;
            int hotbarEnd = inventoryEnd + 9;
            if (slotIndex == 5) {
                if (!this.m_38903_(stack1, containerSize, hotbarEnd, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack1, stack);
            } else if (slotIndex >= containerSize) {
                if (this.isFuel(stack1)) {
                    if (!this.m_38903_(stack1, 4, containerSize, false)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    if (!this.m_38903_(stack1, 0, 4, false)) {
                        return ItemStack.f_41583_;
                    }
                    if (slotIndex < inventoryEnd ? !this.m_38903_(stack1, inventoryEnd, hotbarEnd, false) : slotIndex < hotbarEnd && !this.m_38903_(stack1, containerSize, inventoryEnd, false)) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.m_38903_(stack1, containerSize, hotbarEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack1);
        }
        return stack;
    }

    protected boolean isFuel(ItemStack stack) {
        return Services.HOOKS.getBurnTime(stack) > 0;
    }

    public int getBurnProgress() {
        int cookingProgress = this.data.m_6413_(2);
        int cookingTotalTime = this.data.m_6413_(3);
        return cookingTotalTime != 0 && cookingProgress != 0 ? cookingProgress * 24 / cookingTotalTime : 0;
    }

    public int getLitProgress() {
        int litDuration = this.data.m_6413_(1);
        if (litDuration == 0) {
            litDuration = 200;
        }
        return this.data.m_6413_(0) * 13 / litDuration;
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }

    public Container getContainer() {
        return this.container;
    }
}

