/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.core;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.SSBlocks;
import sereneseasons.api.SSItems;
import sereneseasons.core.ClientProxy;
import sereneseasons.core.CommonProxy;
import sereneseasons.handler.season.SeasonColorHandlers;
import sereneseasons.init.ModBlocks;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModGameRules;
import sereneseasons.init.ModHandlers;
import sereneseasons.init.ModItems;
import sereneseasons.init.ModTags;

@Mod(value="sereneseasons")
public class SereneSeasons {
    public static final String MOD_ID = "sereneseasons";
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final Logger LOGGER = LogManager.getLogger((String)"sereneseasons");
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"sereneseasons");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"sereneseasons");
    public static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"sereneseasons");

    public SereneSeasons() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::registerTab);
        BLOCK_REGISTER.register(bus);
        BLOCK_ENTITY_REGISTER.register(bus);
        ITEM_REGISTER.register(bus);
        ModBlocks.setup();
        ModItems.setup();
        ModHandlers.init();
        ModConfig.init();
        ModGameRules.init();
        ModTags.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            SeasonColorHandlers.setup();
            proxy.registerItemModelsProperties();
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
    }

    private void registerTab(CreativeModeTabEvent.Register event) {
        List<RegistryObject<Item>> itemBlacklist = List.of(SSItems.SS_ICON);
        List blockBlacklist = List.of();
        event.registerCreativeModeTab(new ResourceLocation(MOD_ID, "main"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)SSItems.SS_ICON.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.tabSereneSeasons")).m_257501_((displayParameters, output) -> {
            for (Field field : SSItems.class.getFields()) {
                if (field.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject item = (RegistryObject)field.get(null);
                    if (itemBlacklist.contains(item)) continue;
                    output.m_246342_(new ItemStack((ItemLike)item.get()));
                }
                catch (IllegalAccessException item) {
                    // empty catch block
                }
            }
            for (Field field : SSBlocks.class.getFields()) {
                if (field.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject block = (RegistryObject)field.get(null);
                    if (blockBlacklist.contains(block)) continue;
                    output.m_246342_(new ItemStack((ItemLike)block.get()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }));
    }
}

