/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.paperdoll;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.paperdoll.PaperDollRenderer;
import dev.tr7zw.paperdoll.PaperDollSettings;
import dev.tr7zw.paperdoll.config.ConfigScreenProvider;
import dev.tr7zw.paperdoll.forge.PaperDollEvents;
import dev.tr7zw.paperdoll.util.ModLoaderUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaperDollShared {
    public static final Logger LOGGER = LogManager.getLogger((String)"PaperDoll");
    public static PaperDollShared instance;
    private final File settingsFile = new File("config", "paperdoll.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public PaperDollSettings settings = new PaperDollSettings();
    public PaperDollRenderer renderer;

    public void init() {
        instance = this;
        LOGGER.info("Loading PaperDoll!");
        this.renderer = new PaperDollRenderer();
        ModLoaderUtil.disableDisplayTest();
        ModLoaderUtil.registerConfigScreen(ConfigScreenProvider::createConfigScreen);
        if (this.settingsFile.exists()) {
            try {
                this.settings = (PaperDollSettings)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), PaperDollSettings.class);
            }
            catch (Exception ex) {
                LOGGER.warn("Error while loading config! Creating a new one!", (Throwable)ex);
            }
        }
        if (this.settings == null) {
            this.settings = new PaperDollSettings();
            this.writeSettings();
        }
        ModLoaderUtil.registerForgeEvent(new PaperDollEvents()::onOverlay);
    }

    public void writeSettings() {
        try {
            if (this.settingsFile.exists()) {
                this.settingsFile.delete();
            }
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.settings).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            LOGGER.warn("Error while saving config!", (Throwable)e1);
        }
    }
}

