/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.item.v2.LegacySmithingTransformRecipe;
import fuzs.puzzleslib.impl.core.BiomeLoadingHandler;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.BiomeModificationsContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.CreativeModeTabContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.DataPackSourcesContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.EntityAttributesCreateContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.EntityAttributesModifyContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.FlammableBlocksContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.FuelBurnTimesContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.SpawnPlacementsContextForgeImpl;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public final class ForgeModConstructor {
    private ForgeModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId, ContentRegistrationFlags ... contentRegistrations) {
        ModContainerHelper.findModEventBus(modId).ifPresent(modEventBus -> {
            HashMultimap biomeModifications = HashMultimap.create();
            ForgeModConstructor.registerContent(modId, modEventBus, (Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification>)biomeModifications, contentRegistrations);
            ForgeModConstructor.registerModHandlers(constructor, modEventBus, (Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification>)biomeModifications, contentRegistrations);
            ForgeModConstructor.registerHandlers(constructor);
            constructor.onConstructMod();
        });
    }

    private static void registerContent(String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification> biomeModifications, ContentRegistrationFlags[] contentRegistrations) {
        if (ArrayUtils.contains((Object[])contentRegistrations, (Object)((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS))) {
            BiomeLoadingHandler.register(modId, modEventBus, biomeModifications);
        }
        if (ArrayUtils.contains((Object[])contentRegistrations, (Object)((Object)ContentRegistrationFlags.LEGACY_SMITHING))) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.RECIPE_SERIALIZERS, (String)modId);
            deferredRegister.register(modEventBus);
            deferredRegister.register("legacy_smithing_transform", LegacySmithingTransformRecipe.Serializer::new);
        }
    }

    private static void registerModHandlers(ModConstructor constructor, IEventBus eventBus, Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification> biomeModifications, ContentRegistrationFlags[] contentRegistrations) {
        eventBus.addListener(evt -> {
            constructor.onCommonSetup(arg_0 -> ((FMLCommonSetupEvent)evt).enqueueWork(arg_0));
            constructor.onRegisterFuelBurnTimes(new FuelBurnTimesContextForgeImpl());
            constructor.onRegisterBiomeModifications(new BiomeModificationsContextForgeImpl(biomeModifications, contentRegistrations));
            constructor.onRegisterFlammableBlocks(new FlammableBlocksContextForgeImpl());
        });
        eventBus.addListener(evt -> constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextForgeImpl((SpawnPlacementRegisterEvent)evt)));
        eventBus.addListener(evt -> constructor.onEntityAttributeCreation(new EntityAttributesCreateContextForgeImpl((arg_0, arg_1) -> ((EntityAttributeCreationEvent)evt).put(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onEntityAttributeModification(new EntityAttributesModifyContextForgeImpl((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2))));
        eventBus.addListener(evt -> constructor.onRegisterCreativeModeTabs(new CreativeModeTabContextForgeImpl((arg_0, arg_1) -> ((CreativeModeTabEvent.Register)evt).registerCreativeModeTab(arg_0, arg_1))));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.SERVER_DATA) {
                constructor.onAddDataPackFinders(new DataPackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
            }
        });
    }

    private static void registerHandlers(ModConstructor constructor) {
        MinecraftForge.EVENT_BUS.addListener(evt -> constructor.onRegisterDataPackReloadListeners(new AddReloadListenersContextForgeImpl(arg_0 -> ((AddReloadListenerEvent)evt).addListener(arg_0))));
    }
}

