/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.common.block;

import enemeez.simplefarming.common.block.GrapevineSourceBlock;
import enemeez.simplefarming.common.registries.ModBlocks;
import enemeez.simplefarming.common.registries.ModTags;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrellisBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty CAN_GROW = BooleanProperty.m_61465_((String)"can_grow");
    public static final BooleanProperty CAN_SPREAD = BooleanProperty.m_61465_((String)"can_spread");
    public static final int MIN_DISTANCE = 1;
    public static final int MAX_DISTANCE = 4;
    public static final IntegerProperty DISTANCE_FROM_SOURCE = IntegerProperty.m_61631_((String)"distance_from_source", (int)1, (int)4);
    private final Map<Direction, BooleanProperty> DIRECTION_TO_PROPERTY = Map.of(Direction.NORTH, NORTH, Direction.SOUTH, SOUTH, Direction.EAST, EAST, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN);
    private final VoxelShape NODE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private final VoxelShape CONNECTION_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private final VoxelShape CONNECTION_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private final VoxelShape CONNECTION_EAST = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private final VoxelShape CONNECTION_WEST = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private final VoxelShape CONNECTION_UP = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final VoxelShape CONNECTION_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private final VoxelShape LEAVES_NODE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private final VoxelShape LEAVES_CONNECTION_NORTH = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    private final VoxelShape LEAVES_CONNECTION_SOUTH = Block.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    private final VoxelShape LEAVES_CONNECTION_EAST = Block.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private final VoxelShape LEAVES_CONNECTION_WEST = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    private final VoxelShape LEAVES_CONNECTION_UP = Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final VoxelShape LEAVES_CONNECTION_DOWN = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);

    public TrellisBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CAN_SPREAD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE_FROM_SOURCE, (Comparable)Integer.valueOf(4)));
    }

    private BlockState updateConnections(BlockState pState, Map<Direction, Boolean> map) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)map.getOrDefault(Direction.NORTH, false))).m_61124_((Property)SOUTH, (Comparable)map.getOrDefault(Direction.SOUTH, false))).m_61124_((Property)EAST, (Comparable)map.getOrDefault(Direction.EAST, false))).m_61124_((Property)WEST, (Comparable)map.getOrDefault(Direction.WEST, false))).m_61124_((Property)UP, (Comparable)map.getOrDefault(Direction.UP, false))).m_61124_((Property)DOWN, (Comparable)map.getOrDefault(Direction.DOWN, false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, CAN_GROW, CAN_SPREAD, DISTANCE_FROM_SOURCE});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)CAN_GROW) == false ? Shapes.m_83124_((VoxelShape)this.NODE, (VoxelShape[])new VoxelShape[]{(Boolean)pState.m_61143_((Property)NORTH) != false ? this.CONNECTION_NORTH : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)SOUTH) != false ? this.CONNECTION_SOUTH : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)EAST) != false ? this.CONNECTION_EAST : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)WEST) != false ? this.CONNECTION_WEST : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)UP) != false ? this.CONNECTION_UP : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)DOWN) != false ? this.CONNECTION_DOWN : Shapes.m_83040_()}) : Shapes.m_83124_((VoxelShape)this.LEAVES_NODE, (VoxelShape[])new VoxelShape[]{(Boolean)pState.m_61143_((Property)NORTH) != false ? this.LEAVES_CONNECTION_NORTH : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)SOUTH) != false ? this.LEAVES_CONNECTION_SOUTH : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)EAST) != false ? this.LEAVES_CONNECTION_EAST : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)WEST) != false ? this.LEAVES_CONNECTION_WEST : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)UP) != false ? this.LEAVES_CONNECTION_UP : Shapes.m_83040_(), (Boolean)pState.m_61143_((Property)DOWN) != false ? this.LEAVES_CONNECTION_DOWN : Shapes.m_83040_()});
    }

    private Boolean canConnect(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof TrellisBlock || block instanceof GrapevineSourceBlock || !TrellisBlock.m_152463_((BlockState)state) && state.m_60767_().m_76333_() && !state.m_204336_(ModTags.TRELLIS_BLACKLIST);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        HashMap<Direction, Boolean> connections = new HashMap<Direction, Boolean>();
        Stream.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN).forEach(dir -> connections.put((Direction)dir, this.canConnect(level.m_8055_(pos.m_121945_(dir)))));
        return this.updateConnections(this.m_49966_(), connections);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return (BlockState)pState.m_61124_((Property)this.DIRECTION_TO_PROPERTY.get(pDirection), (Comparable)this.canConnect(pNeighborState));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)CAN_SPREAD) != false || (Boolean)pState.m_61143_((Property)CAN_GROW) != false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)CAN_GROW)).booleanValue() && pLevel.m_8055_(pPos.m_7495_()) == Blocks.f_50016_.m_49966_()) {
            pLevel.m_7731_(pPos.m_7495_(), ((Block)ModBlocks.GRAPEVINE.get()).m_49966_(), 2);
        }
        if (((Boolean)pState.m_61143_((Property)CAN_SPREAD)).booleanValue()) {
            Stream.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN).forEach(dir -> {
                BlockPos neighborPos = pPos.m_121945_(dir);
                BlockState neighborState = pLevel.m_8055_(neighborPos);
                if (neighborState.m_60734_() instanceof TrellisBlock && !((Boolean)neighborState.m_61143_((Property)CAN_GROW)).booleanValue()) {
                    int dist = (Integer)pState.m_61143_((Property)DISTANCE_FROM_SOURCE);
                    pLevel.m_7731_(neighborPos, (BlockState)((BlockState)((BlockState)neighborState.m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CAN_SPREAD, (Comparable)Boolean.valueOf(dist + 1 < 4))).m_61124_((Property)DISTANCE_FROM_SOURCE, (Comparable)Integer.valueOf(dist + 1)), 2);
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)CAN_SPREAD, (Comparable)Boolean.valueOf(false)), 2);
                }
            });
        }
    }
}

