/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.common.block.entity;

import enemeez.simplefarming.common.block.menu.FermenterMenu;
import enemeez.simplefarming.common.item.crafting.FermenterRecipe;
import enemeez.simplefarming.common.registries.ModBlockEntities;
import enemeez.simplefarming.common.registries.ModTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermenterBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_BOTTLE = 1;
    private static final int SLOT_RESULT = 2;
    private static final int CONTAINER_SIZE = 3;
    private static final int CONTAINER_DATA_SIZE = 2;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1, 2};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private int progress = 0;
    private int totalTime = 2000;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> FermenterBlockEntity.this.progress;
                case 1 -> FermenterBlockEntity.this.totalTime;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    FermenterBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    FermenterBlockEntity.this.totalTime = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public FermenterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FERMENTER.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.fermenter");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.progress = pTag.m_128451_("Progress");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        pTag.m_128405_("Progress", this.progress);
    }

    public void dropContents() {
        if (this.f_58857_ != null) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, this.items);
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FermenterBlockEntity entity) {
        Optional recipe;
        if (FermenterBlockEntity.canCraft(entity) && (recipe = level.m_7465_().m_44015_((RecipeType)FermenterRecipe.Type.INSTANCE, (Container)entity, level)).isPresent()) {
            ++entity.progress;
            if (entity.progress == entity.totalTime) {
                entity.progress = 0;
                ItemStack input = (ItemStack)entity.items.get(0);
                ItemStack bottle = (ItemStack)entity.items.get(1);
                entity.items.set(0, (Object)(input.m_41613_() > 0 ? new ItemStack((ItemLike)input.m_41720_(), input.m_41613_() - 1) : ItemStack.f_41583_));
                entity.items.set(1, (Object)(bottle.m_41613_() > 0 ? new ItemStack((ItemLike)bottle.m_41720_(), bottle.m_41613_() - 1) : ItemStack.f_41583_));
                entity.items.set(2, (Object)new ItemStack((ItemLike)((FermenterRecipe)recipe.get()).m_8043_(level.m_9598_()).m_41720_()));
            }
            FermenterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        } else {
            entity.progress = 0;
            FermenterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    private static boolean canCraft(FermenterBlockEntity entity) {
        return ((ItemStack)entity.items.get(1)).m_41720_() == Items.f_42590_ && entity.items.get(2) == ItemStack.f_41583_;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FermenterMenu(pContainerId, pPlayerInventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.m_41619_() && pStack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)pStack, (ItemStack)itemstack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pSlot == 0 && !flag) {
            this.progress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        if (pIndex == 0) {
            return pItemStack.m_204117_(ModTags.FERMENTABLE);
        }
        if (pIndex == 1) {
            return pItemStack.m_41720_() == Items.f_42590_;
        }
        return false;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return pIndex == 2;
    }
}

