/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CheckboxButton
extends UButton {
    protected static final ResourceLocation TEXTURE = Checkbox.f_93821_;
    protected boolean checked;
    protected boolean drawText;
    protected boolean leftSideText;
    protected boolean dropShadow;

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText) {
        this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE);
    }

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, Button.OnPress pessable) {
        super(x, y, width, height, text, pessable);
        this.checked = checked;
        this.drawText = drawText;
        this.buttonTextureProvider = new TextureProvider(){

            @Override
            public ResourceLocation getTexture() {
                return TEXTURE;
            }

            @Override
            public int getU() {
                return CheckboxButton.this.m_198029_() ? 20 : 0;
            }

            @Override
            public int getV() {
                return CheckboxButton.this.checked ? 20 : 0;
            }

            @Override
            public int getWidth() {
                return 20;
            }

            @Override
            public int getHeight() {
                return 20;
            }
        };
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public boolean isLeftSideText() {
        return this.leftSideText;
    }

    public void setLeftSideText(boolean leftSideText) {
        this.leftSideText = leftSideText;
    }

    public void toggle() {
        this.checked = !this.checked;
    }

    public void m_5691_() {
        this.toggle();
        super.m_5691_();
    }

    @Override
    public void renderWidgetTexture(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RGBA color = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentBackgroundColor(poseStack, mouseY, mouseY, partialTick));
        RenderUtil.drawTexturedQuad(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, this.buttonTextureProvider.getWidth(), this.buttonTextureProvider.getHeight(), this.buttonTextureProvider.getU(), this.buttonTextureProvider.getV(), 64, 64, 0.0f, this.buttonTextureProvider.getTexture(), color);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.drawText) {
            Font font = this.getCurrentTextFont();
            Component message = this.getCurrentText();
            if (message != CommonComponents.f_237098_) {
                float currentScale = this.getCurrentScale(poseStack, mouseX, mouseY, partialTick);
                float positionFactor = 1.0f / currentScale;
                float yStart = (float)(this.f_93621_ + (int)((float)this.f_93619_ - 8.0f * currentScale) / 2) * positionFactor;
                float xStart = this.leftSideText ? ((float)this.f_93620_ - ((float)font.m_92852_((FormattedText)message) * currentScale + 4.0f)) * positionFactor : (float)(this.f_93620_ + this.f_93618_ + 4) * positionFactor;
                int color = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentTextColor(poseStack, mouseY, mouseY, partialTick)).getColorARGB();
                poseStack.m_85836_();
                poseStack.m_85841_(currentScale, currentScale, 0.0f);
                if (this.dropShadow) {
                    font.m_92763_(poseStack, this.getCurrentText(), xStart, yStart, color);
                } else {
                    font.m_92889_(poseStack, this.getCurrentText(), xStart, yStart, color);
                }
                poseStack.m_85849_();
            }
        }
    }

    public void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.focused"));
            } else {
                output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.hovered"));
            }
        }
    }
}

