/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class UEditBox
extends EditBox
implements RenderTickable,
PerspectiveRenderable,
BackgroundColorProvider,
TextSettingsProvider {
    protected static final RGBA BLACK = RGBA.BLACK;
    protected static final RGBA WHITE = RGBA.WHITE;
    protected static final RGBA LIGHT_GRAY = new RGBA(-522133249);
    protected static final RGBA LIGHTER_GRAY = new RGBA(-791621377);
    protected static final RGBA GRAY = new RGBA(-1600085761);
    protected static final RGBA DARKER_GRAY = new RGBA(-2139062017);
    protected static final RGBA DARK_GRAY = new RGBA(0x707070FF);
    protected RGBA backgroundFrameColor;
    protected RGBA unfocusedBackgroundFrameColor;
    protected RGBA backgroundColor;
    protected RGBA textColor;
    protected RGBA disabledTextColor;
    protected RGBA hintTextColor;
    protected RGBA suggestionTextColor;
    protected RGBA cursorColor;

    public UEditBox(Font font, int x, int y, int width, int height, UEditBox previousEditBox, Component title) {
        super(font, x, y, width, height, title);
        this.setPreviousText(previousEditBox);
        this.backgroundFrameColor = WHITE;
        this.unfocusedBackgroundFrameColor = GRAY;
        this.backgroundColor = BLACK;
        this.textColor = LIGHT_GRAY;
        this.disabledTextColor = DARK_GRAY;
        this.hintTextColor = LIGHT_GRAY;
        this.suggestionTextColor = DARKER_GRAY;
        this.cursorColor = LIGHTER_GRAY;
    }

    public RGBA getBackgroundFrameColor() {
        return this.backgroundFrameColor;
    }

    public void setBackgroundFrameColor(RGBA backgroundFrameColor) {
        this.backgroundFrameColor = backgroundFrameColor;
    }

    public RGBA getUnfocusedBackgroundFrameColor() {
        return this.unfocusedBackgroundFrameColor;
    }

    public void setUnfocusedBackgroundFrameColor(RGBA unfocusedBackgroundFrameColor) {
        this.unfocusedBackgroundFrameColor = unfocusedBackgroundFrameColor;
    }

    public RGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGBA backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public RGBA getHintTextColor() {
        return this.hintTextColor;
    }

    public void setHintTextColor(RGBA hintTextColor) {
        this.hintTextColor = hintTextColor;
    }

    public RGBA getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public void setSuggestionTextColor(RGBA suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
    }

    public RGBA getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(RGBA cursorColor) {
        this.cursorColor = cursorColor;
    }

    public void m_94202_(int color) {
        super.m_94202_(color);
        this.setTextColor(RGBA.fromARGB(color));
    }

    public void m_94205_(int color) {
        super.m_94205_(color);
        this.setDisabledTextColor(RGBA.fromARGB(color));
    }

    public void setPreviousText(UEditBox textField) {
        if (textField != null) {
            this.f_94093_ = textField.f_94093_;
            this.f_94094_ = textField.f_94094_;
            this.f_94100_ = textField.f_94100_;
            this.f_94101_ = textField.f_94101_;
            this.f_94102_ = textField.f_94102_;
        }
    }

    @Override
    public void renderTick() {
        this.m_94120_();
    }

    public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(poseStack, mouseX, mouseY, partialTick);
        this.renderForeground(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_94096_) {
            UEditBox.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentBackgroundFrameColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
            UEditBox.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentBackgroundColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RGBA currentTextColor = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentTextColor(poseStack, mouseX, mouseY, partialTick));
        String currentText = this.f_94092_.m_92834_(this.f_94093_.substring(this.f_94100_), this.m_94210_());
        int cursorOffset = this.f_94101_ - this.f_94100_;
        int selectionOffset = Math.min(this.f_94102_ - this.f_94100_, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.m_93696_() && this.f_94095_ / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.f_94101_ < this.f_94093_.length() || this.f_94093_.length() >= this.f_94094_;
        int xOffset = this.f_94096_ ? this.f_93620_ + 4 : this.f_93620_;
        int yOffset = this.f_94096_ ? this.f_93621_ + (this.f_93619_ - 8) / 2 : this.f_93621_;
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = this.f_94092_.m_92744_(poseStack, (FormattedCharSequence)this.f_94091_.apply(firstTextPart, this.f_94100_), (float)xOffset, (float)yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? xOffset + this.f_93618_ : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            this.f_94092_.m_92744_(poseStack, (FormattedCharSequence)this.f_94091_.apply(currentText.substring(cursorOffset), this.f_94101_), (float)leftRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
        }
        if (this.f_256828_ != null && currentText.isEmpty() && !this.m_93696_()) {
            this.f_94092_.m_92763_(poseStack, this.f_256828_, (float)leftRenderedTextX, (float)yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentHintTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (!isCursorInTheMiddle && this.f_94088_ != null) {
            this.f_94092_.m_92750_(poseStack, this.f_94088_, (float)(rightRenderedTextX - 1), (float)yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentSuggestionTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)rightRenderedTextX, (int)(yOffset - 1), (int)(rightRenderedTextX + 1), (int)(yOffset + 1 + 9), (int)WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentCursorColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
            } else {
                this.f_94092_.m_92750_(poseStack, "_", (float)rightRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
            }
        }
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.f_94092_.m_92895_(currentText.substring(0, selectionOffset));
            this.m_264315_(poseStack, rightRenderedTextX, yOffset - 1, selectedX - 1, yOffset + 1 + 9);
        }
    }

    @Override
    public RGBA getCurrentBackgroundColor(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        return this.backgroundColor;
    }

    public RGBA getCurrentBackgroundFrameColor(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        return this.m_93696_() ? this.backgroundFrameColor : this.unfocusedBackgroundFrameColor;
    }

    @Override
    public RGBA getCurrentTextColor(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        return this.f_94098_ ? this.textColor : this.disabledTextColor;
    }

    public RGBA getCurrentHintTextColor(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        return this.hintTextColor;
    }

    public RGBA getCurrentSuggestionTextColor(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        return this.suggestionTextColor;
    }

    public RGBA getCurrentCursorColor(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        return this.cursorColor;
    }
}

