/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import info.u_team.u_team_core.util.LevelUtil;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class DimensionTeleportSubCommand {
    private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.dimteleport.success.";

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"dimteleport").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> DimensionTeleportSubCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> DimensionTeleportSubCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension"), Vec3Argument.m_120844_((CommandContext)context, (String)"location")))).then(Commands.m_82129_((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).then(Commands.m_82129_((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).executes(context -> DimensionTeleportSubCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension"), Vec3Argument.m_120844_((CommandContext)context, (String)"location"), FloatArgumentType.getFloat((CommandContext)context, (String)"yaw"), FloatArgumentType.getFloat((CommandContext)context, (String)"pitch"))))))));
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level) {
        targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, entity.m_20182_()));
        if (targets.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.uteamcore.dimteleport.success.single", (Object[])new Object[]{targets.iterator().next().m_5446_(), level.m_46472_().m_135782_()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.uteamcore.dimteleport.success.multiple", (Object[])new Object[]{targets.size(), level.m_46472_().m_135782_()}), true);
        }
        return 0;
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Vec3 pos) {
        targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, pos));
        DimensionTeleportSubCommand.sendPositionInfo(source, targets, level, pos);
        return 0;
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Vec3 pos, float yaw, float pitch) {
        targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), yaw, pitch));
        DimensionTeleportSubCommand.sendPositionInfo(source, targets, level, pos);
        return 0;
    }

    private static void sendPositionInfo(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Vec3 pos) {
        if (targets.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.uteamcore.dimteleport.success.position.single", (Object[])new Object[]{targets.iterator().next().m_5446_(), level.m_46472_().m_135782_(), pos.f_82479_, pos.f_82480_, pos.f_82481_}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.uteamcore.dimteleport.success.position.multiple", (Object[])new Object[]{targets.size(), level.m_46472_().m_135782_(), pos.f_82479_, pos.f_82480_, pos.f_82481_}), true);
        }
    }
}

