/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CommonDeferredRegister<R>
implements Iterable<RegistryObject<R>> {
    private final String modid;
    private final DeferredRegister<R> register;

    public static <C> CommonDeferredRegister<C> create(ResourceKey<? extends Registry<C>> key, String modid) {
        return new CommonDeferredRegister(key, modid);
    }

    public static <C> CommonDeferredRegister<C> create(IForgeRegistry<C> registry, String modid) {
        return new CommonDeferredRegister<C>(registry, modid);
    }

    protected CommonDeferredRegister(ResourceKey<? extends Registry<R>> key, String modid) {
        this.modid = modid;
        this.register = DeferredRegister.create(key, (String)modid);
    }

    protected CommonDeferredRegister(IForgeRegistry<R> registry, String modid) {
        this.modid = modid;
        this.register = DeferredRegister.create(registry, (String)modid);
    }

    public <E extends R> RegistryObject<E> register(String name, Function<ResourceLocation, ? extends E> function) {
        return this.register(name, () -> function.apply(new ResourceLocation(this.modid, name)));
    }

    public <E extends R> RegistryObject<E> register(String name, Supplier<? extends E> supplier) {
        return this.register.register(name, supplier);
    }

    public void register(IEventBus bus) {
        this.register.register(bus);
    }

    public String getModid() {
        return this.modid;
    }

    public Collection<RegistryObject<R>> getEntries() {
        return this.register.getEntries();
    }

    @Override
    public Iterator<RegistryObject<R>> iterator() {
        return this.getEntries().iterator();
    }

    public Iterable<R> entryIterable() {
        return () -> Streams.stream((Iterable)this).map(RegistryObject::get).iterator();
    }

    public DeferredRegister<R> getRegister() {
        return this.register;
    }
}

