/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.pac.gui.claim.element;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.mods.pac.gui.claim.ClaimResultElement;
import xaero.map.mods.pac.gui.claim.ClaimResultElementManager;
import xaero.map.mods.pac.gui.claim.element.ClaimResultElementRenderContext;
import xaero.map.mods.pac.gui.claim.element.ClaimResultElementRenderProvider;
import xaero.map.mods.pac.gui.claim.element.ClaimResultElementRenderReader;

public class ClaimResultElementRenderer
extends MapElementRenderer<ClaimResultElement, ClaimResultElementRenderContext, ClaimResultElementRenderer> {
    private final ClaimResultElementManager manager;

    private ClaimResultElementRenderer(ClaimResultElementManager manager, ClaimResultElementRenderContext context, ClaimResultElementRenderProvider provider, ClaimResultElementRenderReader reader) {
        super(context, provider, reader);
        this.manager = manager;
    }

    @Override
    public void beforeRender(int location, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        ((ClaimResultElementRenderContext)this.context).guiIconBuffer = renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR);
        ((ClaimResultElementRenderContext)this.context).toDelete.clear();
    }

    @Override
    public void afterRender(int location, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        renderTypeBuffers.m_109911_();
        for (ClaimResultElement element : ((ClaimResultElementRenderContext)this.context).toDelete) {
            this.manager.remove(element);
        }
    }

    @Override
    public void renderElementPre(int location, ClaimResultElement element, boolean hovered, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
    }

    @Override
    public boolean renderElement(int location, ClaimResultElement element, boolean hovered, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
        float b;
        float g;
        float r;
        long time = System.currentTimeMillis();
        int iconScale = (int)Math.ceil(optionalScale);
        matrixStack.m_85837_(partialX, partialY, 0.0);
        matrixStack.m_85841_((float)iconScale, (float)iconScale, 1.0f);
        int iconU = element.hasPositive() ? 0 : 32;
        int iconV = 78;
        if (element.hasPositive() == element.hasNegative()) {
            r = 1.0f;
            g = 0.6666667f;
            b = 0.0f;
        } else if (element.hasPositive()) {
            r = 0.0f;
            g = 0.6666667f;
            b = 0.0f;
        } else {
            r = 0.8f;
            g = 0.1f;
            b = 0.1f;
        }
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.m_85850_().m_252922_(), ((ClaimResultElementRenderContext)this.context).guiIconBuffer, -16.0f, -16.0f, iconU, iconV, 32, 32, 32, 32, r, g, b, 1.0f, 256, 256);
        if (hovered) {
            element.setFadeOutStartTime(time);
        }
        if (time - element.getFadeOutStartTime() > 3000L) {
            ((ClaimResultElementRenderContext)this.context).toDelete.add(element);
        }
        return false;
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return true;
    }

    @Override
    public int getOrder() {
        return 150;
    }

    public static final class Builder {
        private ClaimResultElementManager manager;

        private Builder() {
        }

        private Builder setDefault() {
            this.setManager(null);
            return this;
        }

        public Builder setManager(ClaimResultElementManager manager) {
            this.manager = manager;
            return this;
        }

        public ClaimResultElementRenderer build() {
            if (this.manager == null) {
                throw new IllegalStateException();
            }
            return new ClaimResultElementRenderer(this.manager, new ClaimResultElementRenderContext(), new ClaimResultElementRenderProvider(this.manager), new ClaimResultElementRenderReader());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

