/*
 * Decompiled with CFR 0.152.
 */
package net.mm_farming.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.mm_farming.MmFarmingMod;
import net.mm_farming.procedures.ProcHelpCrafterFarmPlusProcedure;
import net.mm_farming.procedures.ProcHelpFarmControllerPlantMinusProcedure;
import net.mm_farming.procedures.ProcHelpFarmControllerPlantPlusProcedure;
import net.mm_farming.procedures.ProcHelpFarmControllerTreePlusProcedure;
import net.mm_farming.world.inventory.GuiHelpFarmControllerPlantMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuiHelpFarmControllerPlantButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GuiHelpFarmControllerPlantButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GuiHelpFarmControllerPlantButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GuiHelpFarmControllerPlantButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GuiHelpFarmControllerPlantButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GuiHelpFarmControllerPlantButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = GuiHelpFarmControllerPlantMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ProcHelpFarmControllerPlantPlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ProcHelpFarmControllerPlantMinusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ProcHelpCrafterFarmPlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ProcHelpFarmControllerTreePlusProcedure.execute((LevelAccessor)world, x, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MmFarmingMod.addNetworkMessage(GuiHelpFarmControllerPlantButtonMessage.class, GuiHelpFarmControllerPlantButtonMessage::buffer, GuiHelpFarmControllerPlantButtonMessage::new, GuiHelpFarmControllerPlantButtonMessage::handler);
    }
}

