/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.client.RenderLayerFactory;
import org.dimdev.dimdoors.api.client.Transformer;
import org.dimdev.dimdoors.client.ModShaders;

@OnlyIn(value=Dist.CLIENT)
public final class DimensionalPortalRenderer {
    public static final ResourceLocation WARP_PATH = DimensionalDoors.id("textures/other/warp.png");
    private static final RenderStateShard.ShaderStateShard DIMENSIONAL_PORTAL_SHADER = new RenderStateShard.ShaderStateShard(ModShaders::getDimensionalPortal);
    private static final RenderType RENDER_LAYER = RenderLayerFactory.create("dimensional_portal", DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.m_110628_().m_173292_(DIMENSIONAL_PORTAL_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(TheEndPortalRenderer.f_112626_, false, false).m_173132_(WARP_PATH, false, false).m_173131_()).m_110691_(false));
    private static final ModelPart MODEL;
    private static final ModelPart TALL_MODEL;

    public static void renderDimensionalPortal(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Transformer transformer, float tickDelta, int light, int overlay) {
        DimensionalPortalRenderer.renderDimensionalPortal(matrixStack, vertexConsumerProvider, transformer, tickDelta, light, overlay, true);
    }

    public static void renderDimensionalPortal(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Transformer transformer, float tickDelta, int light, int overlay, boolean tall) {
        ModelPart model = tall ? TALL_MODEL : MODEL;
        DimensionalPortalRenderer.renderModelWithPortalShader(model, matrixStack, vertexConsumerProvider, transformer, tickDelta, light, overlay);
    }

    public static void renderModelWithPortalShader(ModelPart model, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Transformer transformer, float tickDelta, int light, int overlay) {
        transformer.transform(matrixStack);
        model.m_104301_(matrixStack, vertexConsumerProvider.m_6299_(RENDER_LAYER), light, overlay);
    }

    static {
        HashSet<Direction> directions = new HashSet<Direction>(List.of(Direction.values()));
        ModelPart.Cube small = new ModelPart.Cube(0, 0, 0.2f, 0.2f, -0.1f, 15.8f, 15.8f, 0.01f, 0.0f, 0.0f, 0.0f, false, 1024.0f, 1024.0f, directions);
        MODEL = new ModelPart(Collections.singletonList(small), Collections.emptyMap());
        ModelPart.Cube big = new ModelPart.Cube(0, 0, 0.2f, 0.2f, -0.1f, 15.8f, 31.8f, 0.01f, 0.0f, 0.0f, 0.0f, false, 1024.0f, 1024.0f, directions);
        TALL_MODEL = new ModelPart(Collections.singletonList(big), Collections.emptyMap());
    }
}

