/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.ExceptionHandlingCollector;
import org.dimdev.dimdoors.api.util.Path;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;

public class ResourceUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    public static final BiFunction<String, ResourceLocation, Path<String>> PATH_KEY_PROVIDER = (startingPath, id) -> Path.stringPath(id.m_135827_() + ":" + id.m_135815_().substring(0, id.m_135815_().lastIndexOf(".")).substring(startingPath.length() + (startingPath.endsWith("/") ? 0 : 1)));
    public static final ComposableFunction<JsonElement, Tag> JSON_TO_NBT = json -> (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, json);
    public static final ComposableFunction<Tag, JsonElement> NBT_TO_JSON = json -> (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, json);
    public static final ComposableFunction<InputStream, JsonElement> JSON_READER = inputStream -> (JsonElement)GSON.fromJson((Reader)new InputStreamReader((InputStream)inputStream), JsonElement.class);
    public static final ComposableFunction<InputStream, Tag> NBT_READER = JSON_READER.andThenComposable(JSON_TO_NBT);
    public static final ComposableFunction<InputStream, CompoundTag> COMPRESSED_NBT_READER = inputStream -> {
        try {
            return NbtIo.m_128939_((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    };

    public static <R extends ReferenceSerializable> R loadReferencedResource(ResourceManager manager, String startingPath, String resourceKey, Function<InputStream, R> reader) {
        String[] splitResourceKey = resourceKey.split("\\|");
        HashMultimap flags = HashMultimap.create();
        flags.put((Object)"resource_key", (Object)resourceKey);
        for (int i = 0; i < splitResourceKey.length - 1; ++i) {
            String keyValuePair = splitResourceKey[i];
            int splitIndex = keyValuePair.indexOf(58);
            if (splitIndex == -1) continue;
            flags.put((Object)keyValuePair.substring(0, splitIndex), (Object)keyValuePair.substring(splitIndex + 1));
        }
        String identifier = splitResourceKey[splitResourceKey.length - 1];
        int identifierSplitIndex = identifier.indexOf(58);
        ReferenceSerializable resource = (ReferenceSerializable)ResourceUtil.loadResource(manager, new ResourceLocation(identifier.substring(0, identifierSplitIndex), startingPath + identifier.substring(identifierSplitIndex + 1)), reader);
        resource.processFlags((Multimap<String, String>)flags);
        return (R)resource;
    }

    public static <R> R loadResource(ResourceManager manager, ResourceLocation resourceKey, Function<InputStream, R> reader) {
        try {
            return reader.apply(((Resource)manager.m_213713_(resourceKey).get()).m_215507_());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, T, M extends Map<K, T>> CompletableFuture<M> loadResourcePathToMap(ResourceManager manager, String startingPath, String extension, M map, BiFunction<InputStream, K, T> reader, BiFunction<String, ResourceLocation, K> keyProvider) {
        Map ids = manager.m_214159_(startingPath, str -> str.m_135815_().endsWith(extension));
        return CompletableFuture.supplyAsync(() -> {
            map.putAll((Map)((Stream)ids.entrySet().parallelStream().unordered()).collect(new ExceptionHandlingCollector(Collectors.toConcurrentMap(id -> keyProvider.apply(startingPath, (ResourceLocation)id.getKey()), id -> {
                try {
                    return reader.apply(((Resource)id.getValue()).m_215507_(), keyProvider.apply(startingPath, (ResourceLocation)id.getKey()));
                }
                catch (IOException | RuntimeException e) {
                    throw new RuntimeException(e);
                }
            }), (a, id, exception) -> LOGGER.error("Error loading resource: " + id, (Throwable)exception))));
            return map;
        });
    }

    public static <T, M extends Collection<T>> CompletableFuture<M> loadResourcePathToCollection(ResourceManager manager, String startingPath, String extension, M collection, BiFunction<InputStream, ResourceLocation, T> reader) {
        Map ids = manager.m_214159_(startingPath, str -> str.m_135815_().endsWith(extension));
        return CompletableFuture.supplyAsync(() -> {
            collection.addAll(((Stream)ids.entrySet().parallelStream().unordered()).map(id -> {
                try {
                    return reader.apply(((Resource)id.getValue()).m_215507_(), (ResourceLocation)id.getKey());
                }
                catch (Exception e) {
                    LOGGER.error("Error loading resource: " + id, (Throwable)e);
                    return null;
                }
            }).collect(Collectors.filtering(Objects::nonNull, Collectors.toList())));
            return collection;
        });
    }

    public static interface ComposableFunction<T, R>
    extends Function<T, R> {
        default public <K, V> BiFunction<T, K, V> andThenReader(BiFunction<R, K, V> function) {
            return (t, k) -> function.apply(this.apply(t), k);
        }

        default public <K> BiFunction<T, K, R> composeIdentity() {
            return (t, k) -> this.apply(t);
        }

        default public <V> ComposableFunction<T, V> andThenComposable(Function<? super R, ? extends V> after) {
            return t -> after.apply((R)this.apply(t));
        }
    }
}

