/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import net.minecraft.core.Rotations;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.api.util.math.AbstractMatrixd;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.api.util.math.Matrixd;
import org.dimdev.dimdoors.api.util.math.TransformationMatrixdImpl;
import org.dimdev.dimdoors.api.util.math.Vectord;

public class TransformationMatrix3d
extends TransformationMatrixdImpl<TransformationMatrix3d> {
    public TransformationMatrix3d(double[][] matrix) {
        super(matrix);
    }

    public TransformationMatrix3d(AbstractMatrixd<? extends AbstractMatrixd<?>> matrix) {
        super(matrix);
    }

    public TransformationMatrix3d(Vectord ... vectors) {
        super(vectors);
    }

    public static TransformationMatrix3d identity() {
        return new TransformationMatrix3d(Matrixd.identity(4, 4));
    }

    @Override
    public TransformationMatrix3d construct(double[][] matrix) {
        return new TransformationMatrix3d(matrix);
    }

    @Override
    public TransformationMatrix3d construct(AbstractMatrixd<? extends AbstractMatrixd<?>> matrixd) {
        return new TransformationMatrix3d(matrixd);
    }

    @Override
    public TransformationMatrix3d construct(Vectord ... vectors) {
        return new TransformationMatrix3d(vectors);
    }

    public Vec3 transform(Vec3 vector) {
        Vectord vec = this.transform(new Vectord(vector.f_82479_, vector.f_82480_, vector.f_82481_));
        return new Vec3(vec.get(0), vec.get(1), vec.get(2));
    }

    public Rotations transform(Rotations angle) {
        TransformationMatrix3d rotator = (TransformationMatrix3d)TransformationMatrix3d.builder().rotate(angle).build();
        Vec3 direction = rotator.transform(new Vec3(0.0, 0.0, 1.0));
        Vec3 upwards = rotator.transform(new Vec3(0.0, 1.0, 0.0));
        direction = this.transform(direction);
        upwards = this.transform(upwards);
        return MathUtil.eulerAngle(direction, upwards);
    }

    public static TransformationMatrix3dBuilder builder() {
        return new TransformationMatrix3dBuilder(TransformationMatrix3d.identity());
    }

    public static class TransformationMatrix3dBuilder
    extends TransformationMatrixdImpl.TransformationMatrixdBuilderImpl<TransformationMatrix3dBuilder, TransformationMatrix3d> {
        protected TransformationMatrix3dBuilder(TransformationMatrix3d instance) {
            super(3, instance);
        }

        @Override
        public TransformationMatrix3dBuilder getSelf() {
            return this;
        }

        public TransformationMatrix3dBuilder translate(Vec3 vector) {
            return (TransformationMatrix3dBuilder)this.translate(new Vectord(vector.f_82479_, vector.f_82480_, vector.f_82481_));
        }

        public TransformationMatrix3dBuilder inverseTranslate(Vec3 vector) {
            return (TransformationMatrix3dBuilder)this.translate(new Vectord(-vector.f_82479_, -vector.f_82480_, -vector.f_82481_));
        }

        public TransformationMatrix3dBuilder rotateX(double angle) {
            return (TransformationMatrix3dBuilder)this.rotateAroundBasePlane(angle, 1, 2);
        }

        public TransformationMatrix3dBuilder rotateY(double angle) {
            return (TransformationMatrix3dBuilder)this.rotateAroundBasePlane(angle, 2, 0);
        }

        public TransformationMatrix3dBuilder rotateZ(double angle) {
            return (TransformationMatrix3dBuilder)this.rotateAroundBasePlane(angle, 0, 1);
        }

        public TransformationMatrix3dBuilder rotate(Rotations angle) {
            return this.rotateZ(Math.toRadians(angle.m_123158_())).rotateX(Math.toRadians(angle.m_123156_())).rotateY(Math.toRadians(-angle.m_123157_()));
        }

        public TransformationMatrix3dBuilder inverseRotate(Rotations angle) {
            return this.rotateZ(-Math.toRadians(angle.m_123158_())).rotateX(-Math.toRadians(angle.m_123156_())).rotateY(-Math.toRadians(-angle.m_123157_()));
        }
    }
}

