/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.WaterLoggableBlockWithEntity;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.particle.client.RiftParticleOptions;
import org.dimdev.dimdoors.world.ModDimensions;
import org.jetbrains.annotations.Nullable;

public class DetachedRiftBlock
extends WaterLoggableBlockWithEntity
implements RiftProvider<DetachedRiftBlockEntity>,
SimpleWaterloggedBlock {
    public static final String ID = "rift";

    public DetachedRiftBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public DetachedRiftBlockEntity getRift(Level world, BlockPos pos, BlockState state) {
        return (DetachedRiftBlockEntity)world.m_7702_(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof DetachedRiftBlockEntity)) {
            return;
        }
        DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)blockEntity;
        boolean outsidePocket = !ModDimensions.isPocketDimension(world);
        double speed = 0.1;
        if (rift.closing) {
            world.m_7106_((ParticleOptions)RiftParticleOptions.of(outsidePocket), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, rand.m_188583_() * speed, rand.m_188583_() * speed, rand.m_188583_() * speed);
        }
        world.m_7106_((ParticleOptions)RiftParticleOptions.of(outsidePocket, rift.stabilized), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, rand.m_188583_() * speed, rand.m_188583_() * speed, rand.m_188583_() * speed);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DetachedRiftBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return DimensionalPortalBlock.Dummy.checkType(type, (BlockEntityType)ModBlockEntityTypes.DETACHED_RIFT.get(), DetachedRiftBlockEntity::tick);
    }
}

