/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.TesselatingLoomBlockEntity;
import org.dimdev.dimdoors.screen.TessellatingContainer;
import org.jetbrains.annotations.Nullable;

public class TesselatingLoomBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final String DISPLAY_NAME = "";

    public TesselatingLoomBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (!oldState.m_60713_(newState.m_60734_()) && (tileEntity = worldIn.m_7702_(pos)) instanceof TesselatingLoomBlockEntity) {
            NonNullList<ItemStack> inventory = ((TesselatingLoomBlockEntity)tileEntity).inventory;
            Containers.m_19010_((Level)worldIn, (BlockPos)pos, inventory);
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntityTicker<TesselatingLoomBlockEntity> m_142354_(Level level, BlockState blockState, BlockEntityType entityType) {
        return TesselatingLoomBlock.createFurnaceTicker(level, entityType, (BlockEntityType<TesselatingLoomBlockEntity>)((BlockEntityType)ModBlockEntityTypes.TESSELATING_LOOM.get()));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos bpos, BlockState bstate) {
        return new TesselatingLoomBlockEntity(bpos, bstate);
    }

    protected void openContainer(Level level, BlockPos bpos, Player player) {
        BlockEntity be = level.m_7702_(bpos);
        if (!(be instanceof TesselatingLoomBlockEntity)) {
            throw new IllegalStateException("Our named container provider is missing!");
        }
        player.m_5893_((MenuProvider)be);
        player.m_36220_(Stats.f_12966_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!level.m_5776_()) {
            this.openContainer(level, blockPos, player);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return TessellatingContainer.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    protected static BlockEntityTicker<TesselatingLoomBlockEntity> createFurnaceTicker(Level level, BlockEntityType<?> entityType, BlockEntityType<TesselatingLoomBlockEntity> entityTypeE) {
        return level.m_5776_() ? null : DimensionalPortalBlock.Dummy.checkType(entityType, entityTypeE, TesselatingLoomBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

