/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.block.entity.MutableBlockEntityType;
import org.dimdev.dimdoors.block.DoorSoundProvider;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.item.door.DimensionalDoorItemRegistrar;

public class DimensionalDoorBlockRegistrar {
    private static final String PREFIX = "block_ag_dim_";
    private final Registrar<Block> registry;
    private final DimensionalDoorItemRegistrar itemRegistrar;
    private final BiMap<ResourceLocation, ResourceLocation> mappedDoorBlocks = HashBiMap.create();

    public DimensionalDoorBlockRegistrar(DimensionalDoorItemRegistrar itemRegistrar) {
        this.registry = RegistrarManager.get((String)"dimdoors").get(Registries.f_256747_);
        this.itemRegistrar = itemRegistrar;
        if (Platform.isFabric()) {
            this.init();
        }
        RegistrarManager.get((String)"dimdoors").forRegistry(Registries.f_256747_, registrar -> new ArrayList<Map.Entry>(registrar.entrySet()).forEach(entry -> this.handleEntry((Registrar<Block>)registrar, ((ResourceKey)entry.getKey()).m_135782_(), (Block)entry.getValue())));
        LifecycleEvent.SETUP.register(() -> this.mappedDoorBlocks.keySet().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7745_(arg_0)).forEach(a -> ((MutableBlockEntityType)((Object)((Object)((Object)ModBlockEntityTypes.ENTRANCE_RIFT.get())))).addBlock((Block)a)));
    }

    private void init() {
        new ArrayList<Map.Entry>(this.registry.entrySet()).forEach(entry -> this.handleEntry(this.registry, ((ResourceKey)entry.getKey()).m_135782_(), (Block)entry.getValue()));
    }

    public void handleEntry(Registrar<Block> registrar, ResourceLocation ResourceLocation2, Block original) {
        if (DimensionalDoors.getConfig().getDoorsConfig().isAllowed(ResourceLocation2)) {
            if (!(original instanceof DimensionalDoorBlock) && original instanceof DoorBlock) {
                DoorBlock doorBlock = (DoorBlock)original;
                this.register(registrar, ResourceLocation2, (DoorSoundProvider)doorBlock, DimensionalDoorBlockRegistrar::createAutoGenDimensionalDoorBlock);
            } else if (!(original instanceof DimensionalTrapdoorBlock) && original instanceof TrapDoorBlock) {
                TrapDoorBlock trapDoorBlock = (TrapDoorBlock)original;
            }
        }
    }

    private void register(Registrar<Block> registrar, ResourceLocation location, DoorSoundProvider original, BiFunction<BlockBehaviour.Properties, DoorSoundProvider, Block> constructor) {
        ResourceLocation gennedId = DimensionalDoors.id(PREFIX + location.m_135827_() + "_" + location.m_135815_());
        if (this.mappedDoorBlocks.containsKey((Object)gennedId)) {
            return;
        }
        Block dimBlock = (Block)registrar.register(gennedId, () -> (Block)constructor.apply(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)original)), original)).get();
        this.mappedDoorBlocks.put((Object)gennedId, (Object)location);
        this.itemRegistrar.notifyBlockMapped((Block)original, dimBlock);
        if (Platform.getEnvironment() == Env.CLIENT) {
            this.putCutout(dimBlock);
        }
    }

    private void putCutout(Block original) {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{original});
    }

    public ResourceLocation get(ResourceLocation ResourceLocation2) {
        return (ResourceLocation)this.mappedDoorBlocks.get((Object)ResourceLocation2);
    }

    public boolean isMapped(ResourceLocation ResourceLocation2) {
        return this.mappedDoorBlocks.containsKey((Object)ResourceLocation2);
    }

    private static <T extends Comparable<T>> BlockState transferProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }

    private static AutoGenDimensionalDoorBlock createAutoGenDimensionalDoorBlock(BlockBehaviour.Properties settings, final DoorSoundProvider originalBlock) {
        return new AutoGenDimensionalDoorBlock(settings, originalBlock){

            @Override
            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
                DimensionalDoorBlockRegistrar.appendPropertiesOverride(builder, (Block)originalBlock, new Property[]{WATERLOGGED});
            }
        };
    }

    private static AutoGenDimensionalTrapdoorBlock createAutoGenDimensionalTrapdoorBlock(BlockBehaviour.Properties settings, final DoorSoundProvider originalBlock) {
        return new AutoGenDimensionalTrapdoorBlock(settings, originalBlock){

            @Override
            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
                DimensionalDoorBlockRegistrar.appendPropertiesOverride(builder, (Block)originalBlock, new Property[]{f_57517_});
            }
        };
    }

    private static void appendPropertiesOverride(StateDefinition.Builder<Block, BlockState> builder, Block originalBlock, Property<?> ... requiredProperties) {
        HashSet properties = new HashSet(originalBlock.m_49965_().m_61092_());
        properties.addAll(List.of(requiredProperties));
        builder.m_61104_(properties.toArray(new Property[0]));
    }

    private static class AutoGenDimensionalTrapdoorBlock
    extends DimensionalTrapdoorBlock {
        private final Block originalBlock;

        public AutoGenDimensionalTrapdoorBlock(BlockBehaviour.Properties settings, DoorSoundProvider originalBlock) {
            super(settings, originalBlock.getSetType());
            this.originalBlock = (Block)originalBlock;
            BlockState state = (BlockState)this.m_49965_().m_61090_();
            BlockState originalState = this.originalBlock.m_49966_();
            for (Property property : this.originalBlock.m_49966_().m_61147_()) {
                state = DimensionalDoorBlockRegistrar.transferProperty(originalState, state, property);
            }
            this.m_49959_((BlockState)state.m_61124_((Property)f_57517_, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            throw new RuntimeException("AutoGenDimensionalTrapdoorBlock should be instantiated as anonymous inner class overriding appendProperties!");
        }

        public MutableComponent m_49954_() {
            return Component.m_237110_((String)"dimdoors.autogen_block_prefix", (Object[])new Object[]{this.originalBlock.m_49954_()});
        }
    }

    public static class AutoGenDimensionalDoorBlock
    extends DimensionalDoorBlock {
        private final Block originalBlock;

        public AutoGenDimensionalDoorBlock(BlockBehaviour.Properties settings, DoorSoundProvider originalBlock) {
            super(settings, originalBlock.getSetType());
            this.originalBlock = (Block)originalBlock;
            BlockState state = (BlockState)this.m_49965_().m_61090_();
            BlockState originalState = this.originalBlock.m_49966_();
            for (Property property : this.originalBlock.m_49966_().m_61147_()) {
                state = DimensionalDoorBlockRegistrar.transferProperty(originalState, state, property);
            }
            this.m_49959_((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            throw new RuntimeException("AutoGenDimensionalDoorBlock should be instantiated as anonymous inner class overriding appendProperties!");
        }

        public MutableComponent m_49954_() {
            return Component.m_237110_((String)"dimdoors.autogen_block_prefix", (Object[])new Object[]{this.originalBlock.m_49954_()});
        }

        public Block getOriginalBlock() {
            return this.originalBlock;
        }
    }
}

