/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;

public class DetachedRiftBlockEntity
extends RiftBlockEntity {
    private static final RandomSource random = RandomSource.m_216327_();
    public boolean closing = false;
    public boolean stabilized = false;
    public int spawnedEndermanId = 0;
    public float size = 0.0f;
    private boolean unregisterDisabled = false;
    @OnlyIn(value=Dist.CLIENT)
    public double renderAngle;

    public DetachedRiftBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends RiftBlockEntity>)((BlockEntityType)ModBlockEntityTypes.DETACHED_RIFT.get()), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DetachedRiftBlockEntity blockEntity) {
        if (world == null) {
            return;
        }
        if (state.m_60734_() != ModBlocks.DETACHED_RIFT.get()) {
            blockEntity.m_7651_();
            return;
        }
        if (!world.m_5776_() && (double)random.m_188501_() < DimensionalDoors.getConfig().getGeneralConfig().endermanSpawnChance) {
            EnderMan enderman = (EnderMan)EntityType.f_20566_.m_262496_((ServerLevel)world, pos, MobSpawnType.STRUCTURE);
            if (random.m_188500_() < DimensionalDoors.getConfig().getGeneralConfig().endermanAggressiveChance && enderman != null) {
                enderman.m_6710_((LivingEntity)world.m_45930_((Entity)enderman, 50.0));
            }
        }
        if (blockEntity.closing) {
            if (blockEntity.size > 0.0f) {
                blockEntity.size = (float)((double)blockEntity.size - DimensionalDoors.getConfig().getGeneralConfig().riftCloseSpeed);
            } else {
                world.m_7471_(pos, false);
            }
        } else if (!blockEntity.stabilized) {
            blockEntity.size = (float)((double)blockEntity.size + DimensionalDoors.getConfig().getGeneralConfig().riftGrowthSpeed / (double)(blockEntity.size + 1.0f));
        }
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        this.m_6596_();
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.m_6596_();
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        super.serialize(nbt);
        nbt.m_128379_("closing", this.closing);
        nbt.m_128379_("stablized", this.stabilized);
        nbt.m_128405_("spawnedEnderManId", this.spawnedEndermanId);
        nbt.m_128350_("size", this.size);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.closing = nbt.m_128471_("closing");
        this.stabilized = nbt.m_128471_("stablized");
        this.spawnedEndermanId = nbt.m_128451_("spawnedEnderManId");
        this.size = nbt.m_128457_("size");
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public void unregister() {
        if (!this.unregisterDisabled) {
            super.unregister();
        }
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 velocity) {
        if (this.f_58857_ instanceof ServerLevel) {
            TeleportUtil.teleport(entity, this.f_58857_, this.f_58858_, relativeAngle, velocity);
        }
        return true;
    }

    public void setUnregisterDisabled(boolean unregisterDisabled) {
        this.unregisterDisabled = unregisterDisabled;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
    }
}

