/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.recipe.TesselatingRecipe;
import org.dimdev.dimdoors.screen.TessellatingContainer;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.jetbrains.annotations.Nullable;

public class TesselatingLoomBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    public static final int DATA_WEAVING_TIME = 0;
    public static final int DATA_WEAVING_TIME_TOTAL = 1;
    public static final int NUM_DATA_VALUES = 2;
    private static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int DEFAULT_WEAVE_TIME = 200;
    private static final String INVENTORY_TAG = "Inventory";
    private static final String WEAVE_TIME_TAG = "WeaveTime";
    private static final String WEAVE_TIME_TOTAL_TAG = "WeaveTimeTotal";
    public int weaveTime;
    public int weaveTimeTotal;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TesselatingLoomBlockEntity.this.weaveTime;
                case 1 -> TesselatingLoomBlockEntity.this.weaveTimeTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TesselatingLoomBlockEntity.this.weaveTime = value;
                    break;
                }
                case 1: {
                    TesselatingLoomBlockEntity.this.weaveTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public NonNullList<ItemStack> inventory;
    public ItemStack output = ItemStack.f_41583_;
    private Recipe<?> lastRecipe;
    private final List<TessellatingContainer> openContainers = new ArrayList<TessellatingContainer>();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public TesselatingLoomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TESSELATING_LOOM.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag inventoryTag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryTag, this.inventory);
        inventoryTag.m_128365_("Output", (Tag)this.output.m_41739_(new CompoundTag()));
        nbt.m_128365_(INVENTORY_TAG, (Tag)inventoryTag);
        nbt.m_128405_(WEAVE_TIME_TAG, this.weaveTime);
        nbt.m_128405_(WEAVE_TIME_TOTAL_TAG, this.weaveTimeTotal);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag inventoryTag = nbt.m_128469_(INVENTORY_TAG);
        ContainerHelper.m_18973_((CompoundTag)inventoryTag, this.inventory);
        this.output = ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Output"));
        this.weaveTime = nbt.m_128451_(WEAVE_TIME_TAG);
        this.weaveTimeTotal = nbt.m_128451_(WEAVE_TIME_TOTAL_TAG);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new TessellatingContainer(syncId, (Container)this, inv, this.dataAccess);
    }

    public int[] m_7071_(Direction dir) {
        return dir == Direction.DOWN && (!this.output.m_41619_() || this.getCurrentRecipe().isPresent()) ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot > 0 && this.m_8020_(slot).m_41619_();
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot != 0 || !this.output.m_41619_() || this.getCurrentRecipe().isPresent();
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot != 0 && slot <= this.m_6643_();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return this.output.m_41619_();
    }

    public int m_6643_() {
        return 10;
    }

    public boolean isInputEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        if (slot > 0) {
            return (ItemStack)this.inventory.get(slot - 1);
        }
        if (!this.output.m_41619_()) {
            return this.output;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot == 0) {
            return this.output.m_41620_(amount);
        }
        return ContainerHelper.m_18969_(this.inventory, (int)(slot - 1), (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        if (slot == 0) {
            ItemStack output = this.output;
            this.output = ItemStack.f_41583_;
            return output;
        }
        return ContainerHelper.m_18966_(this.inventory, (int)(slot - 1));
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 0) {
            this.output = stack;
            return;
        }
        this.inventory.set(slot - 1, (Object)stack);
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        for (TessellatingContainer c : this.openContainers) {
            c.m_6199_((Container)this);
        }
    }

    public boolean m_6542_(Player player) {
        return player.m_20097_().m_123331_((Vec3i)this.f_58858_) <= 64.0;
    }

    public void m_5809_(StackedContents finder) {
        for (ItemStack stack : this.inventory) {
            finder.m_36491_(stack);
        }
    }

    public void m_6029_(Recipe<?> recipe) {
        this.lastRecipe = recipe;
    }

    public Recipe<?> m_7928_() {
        return this.lastRecipe;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    private Optional<TesselatingRecipe> getCurrentRecipe() {
        TesselatingRecipe mapRecipe;
        if (this.f_58857_ == null || this.m_7983_()) {
            return Optional.empty();
        }
        TesselatingRecipe lastRecipe = (TesselatingRecipe)this.m_7928_();
        RecipeManager manager = this.f_58857_.m_7465_();
        if (lastRecipe != null && (mapRecipe = (TesselatingRecipe)manager.m_44054_((RecipeType)ModRecipeTypes.TESSELATING.get()).get(lastRecipe)) != null && mapRecipe.m_5818_((Container)this, this.f_58857_)) {
            return Optional.of(lastRecipe);
        }
        return manager.m_44015_((RecipeType)ModRecipeTypes.TESSELATING.get(), (Container)this, this.f_58857_);
    }

    private Optional<ItemStack> getResult() {
        Optional<ItemStack> maybe_result = this.getCurrentRecipe().map(recipe -> recipe.m_5874_((Container)this, null));
        return Optional.of(maybe_result.orElse(ItemStack.f_41583_));
    }

    protected boolean canSmelt(ItemStack result, TesselatingRecipe recipe) {
        if (recipe.m_5818_((Container)this, null)) {
            ItemStack outstack = this.output;
            if (outstack.m_41619_()) {
                return true;
            }
            if (!outstack.m_41656_(result)) {
                return false;
            }
            return outstack.m_41613_() + result.m_41613_() <= outstack.m_41741_();
        }
        return false;
    }

    private int getWeavingTime() {
        return this.getCurrentRecipe().map(a -> a.weavingTime()).orElse(200);
    }

    protected void smelt(ItemStack result, TesselatingRecipe recipe) {
        if (recipe.m_142505_()) {
            return;
        }
        if (!result.m_41619_() && this.canSmelt(result, recipe)) {
            ItemStack outstack = this.output.m_41777_();
            if (outstack.m_41619_()) {
                this.output = result.m_41777_();
            } else if (outstack.m_41720_() == result.m_41720_()) {
                this.output.m_41769_(result.m_41613_());
            }
            if (!this.f_58857_.m_5776_()) {
                this.m_6029_(recipe);
            }
            NonNullList<ItemStack> remaining = recipe.m_7457_((Container)this);
            NonNullList drops = NonNullList.m_122779_();
            for (int i = 0; i < 9; ++i) {
                ItemStack current = (ItemStack)this.inventory.get(i);
                ItemStack remainingStack = (ItemStack)remaining.get(i);
                if (!current.m_41619_()) {
                    current.m_41774_(1);
                }
                if (remainingStack.m_41619_()) continue;
                if (current.m_41619_()) {
                    this.inventory.set(i, (Object)remainingStack);
                    continue;
                }
                if (ItemStack.m_41746_((ItemStack)current, (ItemStack)remainingStack) && ItemStack.m_41728_((ItemStack)current, (ItemStack)remainingStack)) {
                    current.m_41769_(remainingStack.m_41613_());
                    continue;
                }
                drops.add((Object)remainingStack);
            }
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, (NonNullList)drops);
        }
    }

    public static void serverTick(Level level, BlockPos blockpos, BlockState blockstate, TesselatingLoomBlockEntity tile) {
        boolean flag1 = false;
        if (!level.m_5776_()) {
            ItemStack result = tile.getResult().orElse(ItemStack.f_41583_);
            Optional<TesselatingRecipe> recipe = tile.getCurrentRecipe();
            if (recipe.isPresent() && !tile.isInputEmpty()) {
                if (tile.canSmelt(result, recipe.get()) && tile.weaveTime <= 0) {
                    tile.weaveTimeTotal = tile.getWeavingTime();
                    tile.weaveTime = 0;
                }
                ++tile.weaveTime;
                if (tile.weaveTime % 60 == 0) {
                    level.m_5594_(null, blockpos, (SoundEvent)ModSoundEvents.TESSELATING_WEAVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (tile.weaveTime >= tile.weaveTimeTotal) {
                    tile.smelt(result, recipe.get());
                    tile.weaveTime = 0;
                    tile.weaveTimeTotal = !tile.isInputEmpty() ? tile.getWeavingTime() : 0;
                    flag1 = true;
                }
            } else {
                tile.weaveTime = 0;
            }
        } else if (tile.weaveTime > 0) {
            tile.weaveTime = Mth.m_14045_((int)(tile.weaveTime - 2), (int)0, (int)tile.weaveTimeTotal);
        }
        if (flag1) {
            tile.m_6596_();
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                TesselatingLoomBlockEntity.createExperience(level, popVec, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        int i = Mth.m_14143_((float)((float)recipeIndex * experience));
        float f = Mth.m_14187_((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)popVec, (int)i);
    }
}

