/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client.tesseract;

import com.flowpowered.math.TrigMath;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector4f;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.api.util.RGBA;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class Plane {
    Vector4f[] vectors;

    public Plane(Vector4f vec1, Vector4f vec2, Vector4f vec3, Vector4f vec4) {
        this.vectors = new Vector4f[]{vec1, vec2, vec3, vec4};
    }

    public void draw(Matrix4f model, VertexConsumer vc, RGBA color, double radian) {
        Plane.drawVertex(model, vc, Plane.rotYW(this.vectors[0], radian), 0, 0, color);
        Plane.drawVertex(model, vc, Plane.rotYW(this.vectors[1], radian), 0, 1, color);
        Plane.drawVertex(model, vc, Plane.rotYW(this.vectors[2], radian), 1, 1, color);
        Plane.drawVertex(model, vc, Plane.rotYW(this.vectors[3], radian), 1, 0, color);
    }

    private static void drawVertex(Matrix4f model, VertexConsumer vc, Vector4f vector, int u, int v, RGBA color) {
        double scalar = 1.0 / (double)(vector.getW() + 1.0f);
        Vector3f scaled = vector.toVector3().mul(scalar);
        vc.m_252986_(model, scaled.getX(), scaled.getY(), scaled.getZ()).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_((float)u, (float)v).m_5752_();
    }

    private static Vector4f rotXW(Vector4f v, double angle) {
        return com.flowpowered.math.matrix.Matrix4f.from((float)TrigMath.cos((double)angle), (float)0.0f, (float)0.0f, (float)TrigMath.sin((double)angle), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)(-TrigMath.sin((double)angle)), (float)0.0f, (float)0.0f, (float)TrigMath.cos((double)angle)).transform(v);
    }

    private static Vector4f rotZW(Vector4f v, double angle) {
        return com.flowpowered.math.matrix.Matrix4f.from((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)TrigMath.cos((double)angle), (float)(-TrigMath.sin((double)angle)), (float)0.0f, (float)0.0f, (float)TrigMath.sin((double)angle), (float)TrigMath.cos((double)angle)).transform(v);
    }

    private static Vector4f rotYW(Vector4f v, double angle) {
        return com.flowpowered.math.matrix.Matrix4f.from((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)TrigMath.cos((double)angle), (float)0.0f, (float)TrigMath.sin((double)angle), (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)(-TrigMath.sin((double)angle)), (float)0.0f, (float)TrigMath.cos((double)angle)).transform(v);
    }

    private static Vector4f rotXY(Vector4f v, double angle) {
        return com.flowpowered.math.matrix.Matrix4f.from((float)TrigMath.cos((double)angle), (float)(-TrigMath.sin((double)angle)), (float)0.0f, (float)0.0f, (float)TrigMath.sin((double)angle), (float)TrigMath.cos((double)angle), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f).transform(v);
    }
}

