/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.command;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicReader;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.command.forge.WorldeditHelperImpl;
import org.dimdev.dimdoors.pockets.PocketTemplate;
import org.dimdev.dimdoors.util.schematic.Schematic;

public class WorldeditHelper {
    static int load(CommandSourceStack source, PocketTemplate template) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        boolean async = DimensionalDoors.getConfig().getPocketsConfig().asyncWorldEditPocketLoading;
        Consumer<Runnable> taskAcceptor = async ? r -> source.m_81377_().execute(r) : Runnable::run;
        Runnable task = () -> {
            Clipboard clipboard;
            CompoundTag nbt = Schematic.toNbt(template.getSchematic());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                NbtIo.m_128947_((CompoundTag)nbt, (OutputStream)stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                clipboard = new SpongeSchematicReader(new NBTInputStream((InputStream)new ByteArrayInputStream(stream.toByteArray()))).read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            taskAcceptor.accept(() -> {
                WorldEdit.getInstance().getSessionManager().get(WorldeditHelper.getSessionOwner(player)).setClipboard(new ClipboardHolder(clipboard));
                source.m_81354_((Component)Component.m_237110_((String)"commands.pocket.loadedSchem", (Object[])new Object[]{template.getId()}), true);
            });
        };
        if (async) {
            CompletableFuture.runAsync(task);
        } else {
            task.run();
        }
        return 1;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SessionOwner getSessionOwner(ServerPlayer player) {
        return WorldeditHelperImpl.getSessionOwner(player);
    }
}

